import {Component, Injector, OnInit} from '@angular/core';
import {MAT_DIALOG_DATA, MatDialog, MatDialogRef} from '@angular/material';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';
import {DaftarKol, DaryaftAzTarafHesabParams, GhestOfHesabDaftari, Jahat} from '../../../../../interfaces';
import {ConnectorService} from '../../../../../services/connector.service';
import {Router} from '@angular/router';
import {NgxPersianNumbersService} from 'ngx-persian-number/src/services/ngx-persian-numbers.service';
import {hasOwnProperty} from 'tslint/lib/utils';

@Component({
  selector: 'app-daryaft-az-taraf-hesab',
  templateUrl: './daryaft-az-taraf-hesab.component.html',
  styleUrls: ['./daryaft-az-taraf-hesab.component.css']
})
export class DaryaftAzTarafHesabComponent implements OnInit {
  pardakhtkonande: any;
  tavassot: any;
  data: DaryaftAzTarafHesabParams = {
    id: null,
    pardakht_konande_id: null,
    tavassot_id: null,
    tarikh_daryaft: null,
    jahat: null,
    babat: null,
    tozihat: null,
    daftar_kol_id: null,
    hesab_daftar_kol_id: null,
    pos_amount: null,
    card_amount: null,
    cash_amount: null,
    cheks: []
  };
  jahatOptions = [
    {
      key: 'خرید خودرو',
      value: Jahat.kharidKhodro
    },
    {
      key: 'حساب دفتری',
      value: Jahat.hesabDaftari
    },
    {
      key: 'دفتر کل',
      value: Jahat.daftarKol
    },
    {
      key: 'اضلاحیه دفتر کل',
      value: Jahat.eslahieDaftarKol
    },
    {
      key: 'اصلاحیه حساب دفتری',
      value: Jahat.eslahieHesabDaftaro
    },
    {
      key: 'فقط حساب دفتری',
      value: Jahat.faghatHesabDaftari
    }
  ];
  daftarKolls: DaftarKol[];
  hesabDaftarKolls: any[] = [];
  banks: any;
  pos: boolean = false;
  card: boolean = false;
  public outer_data: any = null;
  tahvil_date: any = null;
  ghest_data: GhestOfHesabDaftari = null;
  private dialogRef: MatDialogRef<any>;

  total() {
    let t = 0;
    if (this.data.pos_amount) {
      t += +this.data.pos_amount.toString().replace(/,/g, '');
    }
    if (this.data.card_amount) {
      t += +this.data.card_amount.toString().replace(/,/g, '');
    }
    if (this.data.cash_amount) {
      t += +this.data.cash_amount.toString().replace(/,/g, '');
    }
    for (const q of this.data.cheks) {
      if (q.amount === null) {
        continue;
      }
      t += +q.amount.toString().replace(/,/g, '');
    }
    return t;
  }

  constructor(
    public dialog: MatDialog,
    private cs: ConnectorService,
    private r: Router,
    private injector: Injector,
    private ngxNum: NgxPersianNumbersService
  ) {
    this.outer_data = this.injector.get(MAT_DIALOG_DATA, null);
    if (this.outer_data !== null) {
      this.dialogRef = this.injector.get(MatDialogRef);
    }
  }


  selectPardakhtkonande() {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        console.log(user.data.id);
        this.pardakhtkonande = user.data;
        this.data.pardakht_konande_id = user.data.id;
      }
    );
  }

  selectDaryaftKonande() {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        console.log(user.data.id);
        this.tavassot = user.data;
        this.data.tavassot_id = user.data.id;
      }
    );
  }

  getDafatarKolHesabs() {
    const id = this.data.daftar_kol_id;
    const daftarKoll = this.daftarKolls.find(function (el) {
      return el.id === id;
    });
    this.hesabDaftarKolls = daftarKoll.hesabdaftarkol_set;
  }

  getDafatarKolHesab() {
    const id = this.data.hesab_daftar_kol_id;
    const hesabDaftarKoll = this.hesabDaftarKolls.find(function (el) {
      return el.id === id;
    });
    this.card = hesabDaftarKoll.has_card;
    this.pos = hesabDaftarKoll.has_pos;
  }

  setTahvilTime(e) {
    this.data.tarikh_daryaft = e;
  }

  selectCheck() {
    this.data.cheks.push({
      bank: null,
      bank_id: null,
      hesab: null,
      dar_vajh: null,
      number: null,
      code: null,
      shobe: null,
      sub_hesab: null,
      tarikh: null,
      amount: null,
    });
  }

  ngOnInit() {
    Promise.all([
      this.cs.getDaftarKolls().toPromise(),
      this.cs.getBanks().toPromise(),
    ]).then((a: any) => {
      this.daftarKolls = a[0].json();
      this.banks = a[1].json();

      if (this.outer_data !== null) {
        if (hasOwnProperty(this.outer_data, 'id')) {
          this.set_data();
        } else {
          this.set_data2();
        }
      }
    });
  }

  set_data() {
    this.cs.getDaryaft(this.outer_data.id).subscribe(
      (res) => {
        const resp = res.json();
        this.pardakhtkonande = resp.pardakht_konande;
        this.tavassot = resp.tavassot;
        this.tahvil_date = +resp.tarikh_daryaft;
        this.data = {
          id: resp.id,
          pardakht_konande_id: resp.pardakht_konande.id,
          tavassot_id: resp.tavassot.id,
          tarikh_daryaft: +resp.tarikh_daryaft,
          jahat: <Jahat>resp.jahat,
          babat: resp.bAbat,
          tozihat: resp.tozihat,
          daftar_kol_id: resp.hesab_daftar_kol.daftar_kol.id,
          hesab_daftar_kol_id: resp.hesab_daftar_kol.id,
          pos_amount: resp.pos_amount,
          card_amount: resp.card_amount,
          cash_amount: resp.cash,
          cheks: []
        };
        this.getDafatarKolHesabs();
        this.getDafatarKolHesab();
      }
    );
  }

  set_data2() {
    this.ghest_data = this.outer_data['sandogh'];
    this.pardakhtkonande = this.ghest_data.talab_bedeh.shakhs;
    this.data.pardakht_konande_id = this.ghest_data.talab_bedeh.shakhs.id;
    this.data.jahat = Jahat.hesabDaftari;
  }
  send() {
    this.data.card_amount = +this.ngxNum.removeLettersFromString(this.data.card_amount);
    this.data.cash_amount = +this.ngxNum.removeLettersFromString(this.data.cash_amount);
    this.data.pos_amount = +this.ngxNum.removeLettersFromString(this.data.pos_amount);
    for (let i of this.data.cheks) {
      i.amount = +this.ngxNum.removeLettersFromString(i.amount);
    }
    if (this.ghest_data !== null) {
      if (this.total() > this.ghest_data.amount) {
        return;
      }
      this.data['ghest_data'] = this.ghest_data.id;
    }
    this.cs.createDaryaftAzTarafHesab(this.data).subscribe(
      () => {
        if (this.outer_data !== null) {
          this.dialogRef.close();
        } else {
          this.r.navigate(['../hesabdari']);
        }
      }
    );
  }

}
