import {Component, OnInit} from '@angular/core';
import {ActivatedRoute} from '@angular/router';
import {ConnectorService} from '../../../../../services/connector.service';
import {MatDialog} from '@angular/material';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';
import {GhestOfHesabDaftari} from '../../../../../interfaces';
import * as moment from 'jalali-moment';
import {PardakhtBeTarafHesabComponent} from '../pardakht-be-taraf-hesab/pardakht-be-taraf-hesab.component';
import {DaryaftAzTarafHesabComponent} from '../daryaft-az-taraf-hesab/daryaft-az-taraf-hesab.component';

@Component({
  selector: 'app-daily',
  templateUrl: './daily.component.html',
  styleUrls: ['./daily.component.css']
})
export class DailyComponent implements OnInit {
  isLoading: boolean = false;
  // private id: number;
  public data: GhestOfHesabDaftari[] = [];
  amel: any;
  tavasot: any;
  search = {
    az: null,
    ta: null,
    amel: null,
    babat: '',
    tozihat: '',
    tp: '0',
  };
  name: string = '';
  hesabs: string = '';

  datePickerConfig = {
    format: 'YYYY/M/D'
  };
  public ta: any;
  public az: any;
  delete_sandogh: GhestOfHesabDaftari = null;
  delete_desc: string = '';

  constructor(
    private r: ActivatedRoute,
    private cs: ConnectorService,
    private dialog: MatDialog
  ) {
  }


  ngOnInit() {
  }

  changePage() {
    this.isLoading = true;
    const s = {};

    for (const i in this.search) {
      if (this.search[i] === null || this.search[i] === undefined || this.search[i] === '') {
        continue;
      }
      s[i] = this.search[i];
    }

    this.data = [];
    this.cs.getHesabDaftariDaily(s).subscribe(
      (res) => {
        this.data = res.json();
        this.isLoading = false;
      }
    );
  }

  reset() {
    this.search = {
      az: null,
      ta: null,
      amel: null,
      babat: '',
      tozihat: '',
      tp: '0',
    };
    this.amel = null;
  }

  selectUser() {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        this.amel = user.data;
        this.search.amel = user.data.id;
      }
    );
  }

  setDate(e: number) {
    if (e === 0) {
      const today = new Date();
      this.ta = moment(today).format('jYYYY/jMM/jD');
      this.search.ta = Math.round(today.getTime() / 1000);
      this.az = this.ta;
      this.search.az = this.search.ta;
    } else if (e === 1) {
      const today = new Date();
      const c = moment(today);
      c.locale('fa');
      const d = moment(today);
      d.locale('fa');
      const az = c.startOf('week');
      this.az = az.format('jYYYY/jMM/jD');
      this.search.az = az.format('X');

      const ta = d.endOf('week');
      this.ta = ta.format('jYYYY/jMM/jD');
      this.search.ta = ta.format('X');
    } else if (e === 2) {
      const today = new Date();
      const c = moment(today);
      c.locale('fa');
      const d = moment(today);
      d.locale('fa');
      const az = c.startOf('month');
      this.az = az.format('jYYYY/jMM/jD');
      this.search.az = az.format('X');

      const ta = d.endOf('month');
      this.ta = ta.format('jYYYY/jMM/jD');
      this.search.ta = ta.format('X');
    }
  }

  onDateSelected(b: boolean, val: any) {
    if (!val) {
      return;
    }
    const timestamp = new Date(val);
    if (b) {
      this.ta = moment(timestamp).format('jYYYY/jMM/jD');
      this.search.ta = Math.round(timestamp.getTime() / 1000);
    } else {
      this.az = moment(timestamp).format('jYYYY/jMM/jD');
      this.search.az = Math.round(timestamp.getTime() / 1000);
    }
  }

  resetDate(b: boolean) {
    if (b) {
      this.ta = '';
      this.search.ta = null;
    } else {
      this.az = '';
      this.search.az = null;
    }
  }


  delete_ghest(b: boolean | null) {
    const txt = this.delete_desc + '';
    this.delete_desc = '';
    const sandogh = this.delete_sandogh;
    if (b !== null) {
      this.cs.deleteHesabDaftariDaily(
        this.delete_sandogh.id,
        b,
        txt
      ).subscribe(
        () => {
          if (b) {
            this.data = this.data.filter((el) => {
              return el.talab_bedeh.id !== sandogh.talab_bedeh.id;
            });
          } else {
            this.data = this.data.filter((el) => {
              return el.id !== sandogh.id;
            });
          }
        }
      );
    }
    this.delete_sandogh = null;
  }

  new_pardakht(sandogh: GhestOfHesabDaftari) {
    let models;
    if (sandogh.talab_bedeh.is_talab) {
      models = PardakhtBeTarafHesabComponent;
    } else {
      models = DaryaftAzTarafHesabComponent;
    }
    this.dialog.open(models, {
      data: {
        sandogh: sandogh
      },
      width: '1000px',
      minHeight: '300px'
    }).afterClosed().subscribe(
      () => {
        this.changePage();
      }
    );
  }
}
