import {Component, OnInit} from '@angular/core';
import {MatDialog} from '@angular/material';
import {AddDaftarKolComponent} from './add-daftar-kol/add-daftar-kol.component';
import {DaftarKol, HesabDaftarKol} from '../../../../../interfaces';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-daftar-kol',
  templateUrl: './daftar-kol.component.html',
  styleUrls: ['./daftar-kol.component.css']
})
export class DaftarKolComponent implements OnInit {
  public daftars: DaftarKol[];
  public daftarDetail: DaftarKol = null;
  public eDaftar: DaftarKol = null;
  public eDaftar2: DaftarKol = null;
  public deleteingHesab: HesabDaftarKol = null;
  public deleteingDaftar: DaftarKol = null;

  constructor(public dialog: MatDialog, public cs: ConnectorService) {
  }

  getHesabs(h: HesabDaftarKol[]) {
    return (h.map((el, i) => {return el.name;}));
  }

  addHesab(daftar: DaftarKol) {
    const userModal = this.dialog.open(AddDaftarKolComponent, {
      width: '700px'
    });
    userModal.afterClosed().subscribe(
      (hesab) => {
        const key = this.daftars.findIndex(function (el) {
          return el.id === daftar.id;
        });
        this.daftars[key].hesabdaftarkol_set.push(hesab.data);

        this.cs.setDaftarKolls({
          'add': hesab.data.id,
          'id': this.daftars[key].id
        }).subscribe(() => {
        });
      }
    );
  }

  addDaftarKol() {
    this.eDaftar = {
      id: null,
      name: '',
      hesabdaftarkol_set: []
    };
  }

  deleteHesab(do_it: boolean) {
    if (do_it) {
      const q = this.eDaftar2;
      const w = this.deleteingHesab;

      const key = this.daftars.findIndex(function (el) {
        return el.id === q.id;
      });

      const key2 = this.daftars[key].hesabdaftarkol_set.findIndex(function (el) {
        return el.id === w.id;
      });

      this.cs.setDaftarKolls({
        'remove': this.deleteingHesab.id,
        'id': this.daftars[key].id
      }).subscribe(
        () => {

          this.daftars[key].hesabdaftarkol_set.splice(key2, 1);
          this.deleteingHesab = null;
          this.eDaftar2 = null;
        }
      );
    } else {
      this.eDaftar2 = null;
      this.deleteingHesab = null;

    }
  }

  editDaftar(do_it: boolean) {
    if (!do_it) {
      this.eDaftar = null;
      return;
    }
    if (this.eDaftar.id === null) {
      this.cs.newDaftarKolls(this.eDaftar).subscribe(
        (res) => {
          this.daftars.push(res.json());
          this.eDaftar = null;
        }
      );
    } else {
      const q = this.eDaftar;
      this.cs.setDaftarKolls({
        'name': this.eDaftar.name,
        'id': this.eDaftar.id
      }).subscribe(
        () => {
          const key = this.daftars.findIndex(function (el) {
            return el.id === q.id;
          });
          this.daftars[key].name = q.name;
          this.eDaftar = null;
        }
      );
    }
  }

  ngOnInit() {
    this.cs.getDaftarKolls().subscribe(
      (res) => {
        this.daftars = res.json();
      }
    );
  }

  getQuery(daftar: DaftarKol) {
    return {
      name: daftar.name,
      hesabs: (daftar.hesabdaftarkol_set.map((el, i) => {
        return el.name;
      }))
    };
  }

  delHesab(do_it: boolean) {

    if (do_it) {
      const w = this.deleteingDaftar;

      this.cs.deleteDaftarKolls(w.id).subscribe(
        () => {

          this.daftars = this.daftars.filter((el) => {
            return el.id !== w.id;
          });
          this.deleteingDaftar = null;
        }
      );
    } else {
      this.deleteingDaftar = null;

    }
  }
}
