import {Component, Inject, OnInit} from '@angular/core';
import {MAT_DIALOG_DATA, MatDialogRef} from '@angular/material';
import {DaftarKol, HesabDaftarKol} from '../../../../../../interfaces';
import {ConnectorService} from '../../../../../../services/connector.service';
import {AppService} from '../../../../../../services/app.service';

@Component({
  selector: 'app-add-daftar-kol',
  templateUrl: './add-daftar-kol.component.html',
  styleUrls: ['./add-daftar-kol.component.css']
})
export class AddDaftarKolComponent implements OnInit {

  public hesab: HesabDaftarKol;
  public hesabs: HesabDaftarKol[] = [];

  public isLoading;

  constructor(public dialog: MatDialogRef<any>, private cs: ConnectorService) {
  }


  ngOnInit() {
    this.cs.getHesabDaftarKols()
      .subscribe(res => {
        this.hesabs = res.json();
      });
  }

  selectUser(hesab) {
    this.dialog.close({data: hesab});
  }

}
