import {Component, OnInit} from '@angular/core';
import {ActivatedRoute} from '@angular/router';
import {ConnectorService} from '../../../../../services/connector.service';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';
import {MatDialog} from '@angular/material';
import {MinimalSandogh} from '../../../../../interfaces';
import {AppService} from '../../../../../services/app.service';

@Component({
  selector: 'app-daftar-kol-detail',
  templateUrl: './daftar-kol-detail.component.html',
  styleUrls: ['./daftar-kol-detail.component.css']
})
export class DaftarKolDetailComponent implements OnInit {
  isLoading: boolean = false;
  private id: number;
  public data: MinimalSandogh[] = [];
  amel: any;
  tavasot: any;
  search = {
    az: null,
    no: '0',
    amel: null,
    tavasot: null,
    babat: '',
    tozihat: '',
    tarigh: '0',
  };
  totalp = 0;
  totaln = 0;
  name: string = '';
  hesabs: string = '';
  yesterday: number = null;
  readonly jh = {
    KHARID_KHODRO: 'خرید خودرو',
    HESAB_DAFTARI: 'حساب دفتری',
    DAFTAR_KOL: 'دفتر کل',
    ESLAHIE_HESAB_DAFTARI: 'اصلاحیه حساب دفتری',
    ESLAHIE_DAFTAR_KOL: 'اصلاحیه دفتر کل',
    FAGHAT_HESAB_DAFTARI: 'فقط حساب دفتری',
    FORUSH_KHODRO: 'فروش خودرو',
    SANDOGH: 'صندوق'
  };

  constructor(
    private r: ActivatedRoute,
    private cs: ConnectorService,
    private dialog: MatDialog,
    private ap: AppService
  ) {
  }

  ngOnInit() {
    this.search.az = Math.floor((new Date()).getTime() / 1000);
    this.r.paramMap.subscribe((el) => {
      this.id = +el.get('id');
      this.changePage();
    });
    this.r.queryParamMap.subscribe((el) => {
      this.name = el.get('name');
      this.hesabs = el.getAll('hesabs').join(', ');
    });
  }

  changePage() {
    this.isLoading = true;
    const s = {};

    for (const i in this.search) {
      if (this.search[i] === null || this.search[i] === undefined || this.search[i] === '') {
        continue;
      }
      s[i] = this.search[i];
    }

    this.cs.getDaftarKollDetail(this.id, s).subscribe(
      (res) => {
        const data = res.json();
        let dt = data['data'];
        // this.data = data['data'];
        this.data = [];

        this.yesterday = -data['sum'];

        if (this.search.no === '1') {
          dt = dt.filter((el) => {
            return el.sign;
          });
        } else if (this.search.no === '2') {
          dt = dt.filter((el) => {
            return !el.sign;
          });
        }
        const tarigh = +this.search.tarigh;
        for (const i of dt) {
          if (i.pos_amount > 0 && (tarigh === 0 || tarigh === 1)) {
            this.data.push({
              amel: i.amel,
              tavassot: i.tavassot,
              bAbat: i.bAbat,
              sign: i.sign,
              tozihat: i.tozihat,
              amount: i.pos_amount,
              pos_amount: 0,
              cash_amount: 0,
              chek_amount: 0,
              carmozd: 0,
              card_amount: 0,
              created_at: i.created_at,
              tarigh: i.tarigh,
              bank: i.bank,
              jahat: i.jahat,
              tarigh_txt: 'پوز'
            });
          }
          if (i.cash_amount > 0 && (tarigh === 0 || tarigh === 3)) {
            this.data.push({
              amel: i.amel,
              tavassot: i.tavassot,
              bAbat: i.bAbat,
              sign: i.sign,
              tozihat: i.tozihat,
              amount: i.cash_amount,
              bank: i.bank,
              pos_amount: 0,
              cash_amount: 0,
              chek_amount: 0,
              card_amount: 0,
              carmozd: 0,
              created_at: i.created_at,
              tarigh: i.tarigh,
              jahat: i.jahat,
              tarigh_txt: 'نقدی'
            });
          }
          if (i.card_amount > 0 && (tarigh === 0 || tarigh === 2)) {
            this.data.push({
              amel: i.amel,
              tavassot: i.tavassot,
              bAbat: i.bAbat,
              sign: i.sign,
              tozihat: i.tozihat,
              amount: i.card_amount,
              pos_amount: 0,
              cash_amount: 0,
              card_amount: 0,
              carmozd: 0,
              bank: i.bank,
              chek_amount: 0,
              created_at: i.created_at,
              tarigh: i.tarigh,
              jahat: i.jahat,
              tarigh_txt: 'کارت'
            });
          }
          const jomle = [
            'وصول چک به شماره ',
            'پاس چک به شماره '
          ];
          if (i.chek_amount > 0 && (tarigh === 0 || tarigh === 4)) {
            this.data.push({
              amel: i.amel,
              bank: i.bank,
              tavassot: i.tavassot,
              bAbat: jomle[i.sign ? 1 : 0] + i.bAbat,
              sign: i.sign,
              tozihat: i.tozihat,
              amount: i.chek_amount,
              pos_amount: 0,
              cash_amount: 0,
              card_amount: 0,
              carmozd: 0,
              chek_amount: 0,
              created_at: i.created_at,
              tarigh: i.tarigh,
              jahat: i.jahat,
              tarigh_txt: 'چک'
            });
          }
          if (i.carmozd > 0) {
            this.data.push({
              amel: i.amel,
              tavassot: i.tavassot,
              bAbat: i.bAbat,
              sign: i.sign,
              tozihat: i.tozihat,
              amount: i.carmozd,
              pos_amount: 0,
              cash_amount: 0,
              bank: i.bank,
              card_amount: 0,
              carmozd: 0,
              chek_amount: 0,
              created_at: i.created_at,
              tarigh: i.tarigh,
              jahat: i.jahat,
              tarigh_txt: 'کارمزد'
            });
          }
        }

        this.totalp = this.data.reduce((total, dt) => {
          return total + (dt.sign ? 0 : dt.amount);
        }, 0);
        this.totaln = this.data.reduce((total, dt) => {
          return total + (dt.sign ? dt.amount : 0);
        }, 0);
        this.isLoading = false;
      }
    );
  }

  reset() {
    this.search = {
      az: null,
      no: '0',
      amel: null,
      tavasot: null,
      babat: '',
      tozihat: '',
      tarigh: '0',
    };
    this.amel = null;
    this.tavasot = null;
  }


  selectUser(is_amel: boolean) {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        if (is_amel) {
          this.amel = user.data;
          this.search.amel = user.data.id;
        } else {
          this.tavasot = user.data;
          this.search.tavasot = user.data.id;
        }
      }
    );
  }
}
