import {Component, OnInit} from '@angular/core';
import {MatDialog} from '@angular/material';
import {ConnectorService} from '../../../../../services/connector.service';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';

@Component({
  selector: 'app-daftar-chek',
  templateUrl: './daftar-chek.component.html',
  styleUrls: ['./daftar-chek.component.css']
})
export class DaftarChekComponent implements OnInit {
  datas = null;
  readonly tps: string[] = [
    'وصول',
    'برگشت',
    'تعویق',
    'حذف',
    'پاس'
  ];
  public banks: any[];
  pardakhtkonande: any;
  bank: any;
  shomare_chek: any;
  dar_vajh: any;
  code: any;
  shobe: any;
  shomare_hesab: any;
  saheb_hesab: any;
  tarikh_sarresid_ta: any;
  tarikh_sarresid_az: any;
  mablagh: any;
  tp: any;
  daryaft_konande_id: any;
  page_type: any = false;

  constructor(private dialog: MatDialog, private cs: ConnectorService) {
  }

  ngOnInit() {
    this.cs.getBanks()
      .subscribe(res => {
        this.banks = res.json();
        this.c();
      });
  }

  selectPardakhtkonande() {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        console.log(user.data.id);
        this.pardakhtkonande = user.data;
        this.daryaft_konande_id = user.data.id;
      }
    );
  }

  c() {
    this.datas = null;
    setTimeout(() => {
      const s: { [key: string]: any } = {
        'for_daryafti': this.page_type ? 1 : 0
      };

      if (this.bank) {
        s['bank'] = this.bank;
      }

      if (this.daryaft_konande_id) {
        s['dki'] = this.daryaft_konande_id;
      }

      if (this.mablagh) {
        s['mablagh'] = this.mablagh;
      }

      if (this.shomare_chek) {
        s['shomare_chek'] = this.shomare_chek;
      }

      if (this.dar_vajh) {
        s['dar_vajh'] = this.dar_vajh;
      }

      if (this.tarikh_sarresid_ta) {
        s['tarikh_sarresid_ta'] = this.tarikh_sarresid_ta;
      }


      if (this.tarikh_sarresid_az) {
        s['tarikh_sarresid_az'] = this.tarikh_sarresid_az;
      }

      if (this.code) {
        s['code'] = this.code;
      }

      if (this.shobe) {
        s['shobe'] = this.shobe;
      }

      if (this.shomare_hesab) {
        s['shomare_hesab'] = this.shomare_hesab;
      }

      if (this.saheb_hesab) {
        s['saheb_hesab'] = this.saheb_hesab;
      }

      if (this.tp !== undefined) {
        s['type_of'] = this.tp;
      }

      this.datas = s;
    }, 500);
  }

  reset() {
    this.pardakhtkonande = undefined;
    this.bank = undefined;
    this.daryaft_konande_id = undefined;
    this.shomare_chek = undefined;
    this.dar_vajh = undefined;
    this.tarikh_sarresid_ta = undefined;
    this.tarikh_sarresid_az = undefined;
    this.code = undefined;
    this.mablagh = undefined;
    this.shobe = undefined;
    this.shomare_hesab = undefined;
    this.saheb_hesab = undefined;
    this.tp = undefined;
  }
}
