import {Component, Input, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {Router} from '@angular/router';
import {MatDialog} from '@angular/material';
import {checkTypes, ChekDataInterface, ChekStatus} from '../../../../../interfaces';
import {ChekDialogComponent} from '../chek-dialog/chek-dialog.component';
import {hasOwnProperty} from 'tslint/lib/utils';

@Component({
  selector: 'app-daftar-chek-list',
  templateUrl: './daftar-chek-list.component.html',
  styleUrls: ['./daftar-chek-list.component.css']
})
export class DaftarChekListComponent implements OnInit {
  public isLoading;
  public chekListTotal: number = 0;
  public _page_type: boolean = null;
  public chekList: ChekDataInterface[] = [];
  public numOfPages;
  public page = 1;
  private _filters: any = {};
  private old_data = null;
  maping_chek_status_p = [];

  maping_chek_status: {
    status: number,
    value: string,
    icon: string
  }[] = checkTypes;
  maping_chek_status_d = [];

  constructor(public cs: ConnectorService, public router: Router, public dialog: MatDialog) {
    this.maping_chek_status_p = this.maping_chek_status.filter((el) => {
      return el.status !== ChekStatus.VOSUL;
    });
    this.maping_chek_status_d = this.maping_chek_status.filter((el) => {
      return el.status !== ChekStatus.PASS;
    });
  }

  @Input('data')
  set data(val: any) {
    if (val === null || val === undefined) {
      return;
    }
    // if (this.old_data === val) {
    //   return;
    // }
    console.log(this.old_data);
    this.old_data = val;
    if (!hasOwnProperty(this.old_data, 'for_daryafti')) {
      return;
    }

    if (this.old_data['for_daryafti'] !== null) {
      this.old_data['page'] = this.page;
      this._page_type = this.old_data['for_daryafti'];
      this.getChekList();
    }
  }

  getChekList() {
    this.isLoading = true;
    this.cs.getChekList(this.old_data).subscribe(
      (response) => {
        this.isLoading = false;
        this.chekList = response.json().data;
        let tp: number = null;
        if (hasOwnProperty(this.old_data, 'type_of')) {
          tp = +this.old_data['type_of'];
        }
        console.log(tp);
        console.log(this.old_data);
        if (tp !== 4 && tp !== 0 && tp !== 3) {
          this.chekList = this.chekList.filter((el) => {
            return !(el.types[0] || el.types[1] || el.types[3]);
          });
        }
        this.numOfPages = response.json().num_of_pages;
        this.chekListTotal = this.chekList.reduce((total, dt) => {
          return total + dt.mablagh;
        }, 0);
      },
      (error) => {
        console.log(error);
      }
    );
  }

  action(status: number, check: ChekDataInterface) {
    this.dialog.open(ChekDialogComponent, {
      width: '700px',
      // height: '600px',
      minHeight: '300px',
      data: {
        action: status,
        chek: check
      }
    }).afterClosed().subscribe(
      (q) => {
        this.getChekList();
      });
  }


  changePage(i) {
    this.page = i;
    this.old_data['page'] = this.page;
    this.getChekList();
  }

  ngOnInit() {
  }
}
