import {Component, Inject, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {MAT_DIALOG_DATA, MatDialogRef} from '@angular/material';
import {ChekDataInterface, ChekStatus, HesabDaftarKol} from '../../../../../interfaces';
import {hasOwnProperty} from 'tslint/lib/utils';

@Component({
  selector: 'app-chek-dialog',
  templateUrl: './chek-dialog.component.html',
  styleUrls: ['./chek-dialog.component.css']
})
export class ChekDialogComponent implements OnInit {
  public css = ChekStatus;
  public dt = {
    a0: null,
    a1: null,
    a2: null,
    a3: null
  };

  hesabs: HesabDaftarKol[] = [];

  constructor(
    private cs: ConnectorService,
    private dialog: MatDialogRef<any>,
    @Inject(MAT_DIALOG_DATA) public data: { action: number, chek: ChekDataInterface }
  ) {
  }

  ngOnInit() {
    this.cs.getHesabDaftarKols(true).subscribe(
      (res) => {
        this.hesabs = res.json();
      }
    );

    if (hasOwnProperty(this.data, 'id')) {
      this.cs.getChekList({'id': this.data['id']}).subscribe(
        (resp) => {
          console.log(resp.json());
          this.data = {
            action: this.css.EDIT,
            chek: resp.json()
          };
        }
      );
    }
  }


  send() {
    if (this.data.action === -1) {
      this.dialog.close();
    } else if (this.data.action === this.css.EDIT) {
      this.cs.chek_edit(this.data.action, this.data.chek).subscribe(
        () => {
          this.dialog.close();
        }
      );
    } else {
      this.cs.chek_status(this.data.action, this.data.chek.id, this.dt).subscribe(
        () => {
          this.dialog.close();
        }
      );
    }
  }

}
