import {Component, OnInit} from '@angular/core';
import {MatDialog} from '@angular/material';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';
import {Router} from '@angular/router';
import {ConnectorService} from '../../../../../services/connector.service';
import {HesabDaftarKol} from '../../../../../interfaces';

@Component({
  selector: 'app-bank-transactions',
  templateUrl: './bank-transactions.component.html',
  styleUrls: ['./bank-transactions.component.css']
})
export class BankTransactionsComponent implements OnInit {
  public tavasot;
  public data = {
    tarigh: null,
    mabda: null,
    maghsad: null,
    sabt: null,
    amal: null,
    mablagh: null,
    karmozd: null,
    description: null,
    babat: null,
    tavasot_id: null
  };

  public tarighs: string[] = [
    'پوز',
    'نقدی',
    'کارت به کارت',
    'چک بانکی',
    'حواله',
    'چک',
  ];
  public hesabs: HesabDaftarKol[] = [];

  constructor(private dialog: MatDialog, private route: Router, private cs: ConnectorService) {
  }

  ngOnInit() {
    this.cs.getHesabDaftarKols(true).subscribe(
      (res) => {
        this.hesabs = res.json();
      }
    );
  }

  send() {
    this.cs.newTransfer({
      tarigh: +this.data.tarigh,
      mabda_hesab_id: +this.data.mabda,
      maghsad_hesab_id: +this.data.maghsad,
      sabt: +this.data.sabt,
      amal: +this.data.amal,
      mablagh: this.data.mablagh,
      karmozd: this.data.karmozd,
      description: this.data.description,
      babat: this.data.babat,
      tavasot_id: +this.data.tavasot_id
    }).subscribe(
      () => {
        this.route.navigate(['../hesabdari']);
      }
    );
  }

  selectPardakhtkonande() {
    const userModal = this.dialog.open(SearchUsersComponent);
    userModal.afterClosed().subscribe(
      (user) => {
        console.log(user.data.id);
        this.tavasot = user.data;
        this.data.tavasot_id = user.data.id;
      }
    );
  }
}
