import {Component, Inject, OnInit} from '@angular/core';
import {MAT_DIALOG_DATA, MatDialogRef} from '@angular/material';
import {HesabDaftarKol} from '../../../../../../interfaces';
import {ConnectorService} from '../../../../../../services/connector.service';

@Component({
  selector: 'app-edit-account',
  templateUrl: './edit-account.component.html',
  styleUrls: ['./edit-account.component.css']
})
export class EditAccountComponent implements OnInit {
  public banks: any[] = [];
  public isLoading;

  constructor(@Inject(MAT_DIALOG_DATA) public data: { hesab: HesabDaftarKol }, public dialog: MatDialogRef<any>, private cs: ConnectorService) {
  }

  ngOnInit() {
    this.isLoading = true;
    this.cs.getBanks()
      .subscribe(res => {
        this.banks = res.json();
        this.isLoading = false;
      });
    if (this.data.hesab === null) {
      this.data.hesab = {
        id: null,
        name: '',
        has_chek: false,
        has_pos: false,
        has_card: false,
        bank: {
          id: null,
          name: null
        },
        shobe: '',
        code_shobe: '',
        shomare_hesab: '',
        saheb_hesab: '',
        telephone: '',
        tozihat: '',
      };
    }
  }

  save(do_it: boolean = null) {
    if (do_it === false) {
      this.dialog.close();
      return;
    }
    if (do_it === true) {
      this.isLoading = true;
      this.cs.setHesabDaftarKols(this.data.hesab).subscribe(
        () => {
          this.isLoading = false;
          this.dialog.close();
        }
      );
      return;
    }

    this.isLoading = true;
    this.cs.newHesabDaftarKols(this.data.hesab).subscribe(
      (res) => {
        this.isLoading = false;
        this.dialog.close();
      }
    );
  }
}
