import {Component, OnInit} from '@angular/core';
import {MatDialog} from '@angular/material';
import {EditAccountComponent} from './edit-account/edit-account.component';
import {ConnectorService} from '../../../../../services/connector.service';
import {HesabDaftarKol} from '../../../../../interfaces';

@Component({
  selector: 'app-accounts-and-cheks',
  templateUrl: './accounts-and-cheks.component.html',
  styleUrls: ['./accounts-and-cheks.component.css']
})
export class AccountsAndCheksComponent implements OnInit {
  public accounts: HesabDaftarKol[] = [];

  constructor(public dialog: MatDialog, private cs: ConnectorService) {
  }

  addAccount() {
    const accountModal = this.dialog.open(EditAccountComponent, {
      width: '700px', data: {
        hesab: null
      }
    });
    accountModal.afterClosed().subscribe(
      (hesab) => {
        this.getHesabs();
      }
    );
  }

  editAccount(account: HesabDaftarKol) {
    this.dialog.open(EditAccountComponent, {
      width: '700px',
      data: {
        hesab: account
      }
    }).afterClosed().subscribe(
      () => {
        this.getHesabs();
      }
    );
  }

  ngOnInit() {
    this.getHesabs();
  }

  getHesabs() {
    this.cs.getHesabDaftarKols(true).subscribe(
      (res) => {
        this.accounts = res.json();
      }
    );
  }

}
