import {Component, OnInit} from '@angular/core';
import {ActivatedRoute, Router} from '@angular/router';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-single-gholname',
  templateUrl: './single-gholname.component.html',
  styleUrls: ['./single-gholname.component.css']
})
export class SingleGholnameComponent implements OnInit {
  public type;
  public id;

  constructor(public router: Router, public cs: ConnectorService, public route: ActivatedRoute) {
  }

  cancel() {
    this.cs.cancelGholname(this.id).subscribe(
      response => {
        this.router.navigate(['/gholname']);
      }
    );
  }

  setData() {
    this.id = this.route.snapshot.params.id;
    this.type = this.route.snapshot.params.type;
  }

  ngOnInit() {
    this.setData();
  }

}
