import {ChangeDetectorRef, Component, OnInit, ViewChild} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {gholnameSearchParams} from '../../../../../interfaces';
import {ActivatedRoute, Router} from '@angular/router';

@Component({
  selector: 'app-search-in-gholname',
  templateUrl: './search-in-gholname.component.html',
  styleUrls: ['./search-in-gholname.component.css']
})


export class SearchInGholnameComponent implements OnInit {
  public isLoading;

  public searchParams = new gholnameSearchParams();
  @ViewChild('gholameList') gholnameList;

  constructor(public cs: ConnectorService, private r: Router, private ar: ActivatedRoute, private ref: ChangeDetectorRef) {
  }

  searchInGholname() {
    this.searchParams.page = 1;
    this.r.navigate(['./'], {queryParams: this.searchParams, relativeTo: this.ar});
    this.gholnameList.getGholnameList();
  }

  ngOnInit() {
    this.searchParams.import(this.ar.snapshot.queryParams);
    this.ref.detectChanges();
  }
}
