import {Component, Input, OnInit} from '@angular/core';

@Component({
  selector: 'app-print',
  templateUrl: './print.component.html',
  styleUrls: ['./print.component.css']
})
export class PrintComponent implements OnInit {
  @Input('gholname') gholnameData;

  constructor() {
  }

  ngOnInit() {
    document.body.style.background = '#fff';
    document.body.style.color = '#000';

    function resizable(el, factor) {
      var int = Number(factor) || 7.7;

      function resize() {
        el.style.width = ((el.value.length + 1) * int) + 'px';
      }

      var e = 'keyup,keypress,focus,blur,change'.split(',');
      for (var i in e) el.addEventListener(e[i], resize, false);
      resize();
    }
    const q = document.getElementById('txt');
    if (q === null || q===undefined) {
      return;
    }
    resizable(q, 7);
  }

}
