import {Component, OnInit} from '@angular/core';
import {ActivatedRoute} from '@angular/router';
import {ConnectorService} from '../../../../../../services/connector.service';

@Component({
  selector: 'app-print-lizing',
  templateUrl: './print-lizing.component.html',
  styleUrls: ['./print-lizing.component.css']
})
export class PrintLizingComponent implements OnInit {
  public gholnameId;
  public gholnameData;

  constructor(public cs: ConnectorService, public route: ActivatedRoute) {
  }

  getGholnameData() {
    this.cs.getGholnameLizing(this.gholnameId).subscribe(
      (response) => {
        // console.log(response.json());
        this.gholnameData = response.json();
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  setGholnameId() {
    this.gholnameId = this.route.snapshot.params.id;
  }

  ngOnInit() {
    this.setGholnameId();
    this.getGholnameData();
  }
}
