import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {ActivatedRoute} from '@angular/router';

@Component({
  selector: 'app-print-kharid-namayeshgah',
  templateUrl: './print-kharid-namayeshgah.component.html',
  styleUrls: ['./print-kharid-namayeshgah.component.css']
})
export class PrintKharidNamayeshgahComponent implements OnInit {
  public gholnameId;
  public gholnameData;

  constructor(public cs: ConnectorService, public route: ActivatedRoute) {
  }

  setGholnameId() {
    this.gholnameId = this.route.snapshot.params.id;
  }

  getGholnameData() {
    this.cs.getGholnameKharidNamayeshgah(this.gholnameId).subscribe(
      (response) => {
        this.gholnameData = response.json();
        // console.log(response.json());
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  ngOnInit() {
    this.setGholnameId();
    this.getGholnameData();
    document.body.style.background = '#fff';
    document.body.style.color = '#000';
  }

}
