import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {ActivatedRoute} from '@angular/router';

@Component({
  selector: 'app-print-kharid-naghdi',
  templateUrl: './print-kharid-naghdi.component.html',
  styleUrls: ['./print-kharid-naghdi.component.css']
})
export class PrintKharidNaghdiComponent implements OnInit {
  public gholnameId;
  public gholnameData;

  constructor(public cs: ConnectorService, public route: ActivatedRoute) {
  }

  setGholnameId() {
    this.gholnameId = this.route.snapshot.params.id;
  }

  getGholnameData() {
    this.cs.getGholnameNaghdi(this.gholnameId).subscribe(
      (response) => {
        this.gholnameData = response.json();
        // console.log(response.json());
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  ngOnInit() {
    this.setGholnameId();
    this.getGholnameData();
  }

}
