import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {ActivatedRoute} from '@angular/router';

@Component({
  selector: 'app-print-kharid-aghsati',
  templateUrl: './print-kharid-aghsati.component.html',
  styleUrls: ['./print-kharid-aghsati.component.css']
})
export class PrintKharidAghsatiComponent implements OnInit {
  public gholnameId;
  public gholnameData = null;

  constructor(public router: ActivatedRoute, public cs: ConnectorService) {
  }

  getGhoname() {
    this.cs.getGholnameAghsati(this.gholnameId).subscribe(
      (response) => {
        this.gholnameData = response.json();
        // console.log(this.gholnameData);
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  setGhonameId() {
    this.gholnameId = this.router.snapshot.params.id;
  }

  ngOnInit() {
    this.setGhonameId();
    this.getGhoname();
  }

}
