import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../../services/connector.service';
import {ActivatedRoute} from '@angular/router';

@Component({
  selector: 'app-print-gholname-aghsati-ghests',
  templateUrl: './print-gholname-aghsati-ghests.component.html',
  styleUrls: ['./print-gholname-aghsati-ghests.component.css']
})
export class PrintGholnameAghsatiGhestsComponent implements OnInit {
  public gholnameGhestData = [];
  public numOfPages;
  public dataReadyForShow;
  public gholnameId;
  public user;

  constructor(public cs: ConnectorService, public route: ActivatedRoute) {
  }

  getGholnameGhests() {
    this.cs.getGhests(this.gholnameId, 1)
      .subscribe(
        (response) => {
          // console.log(response.json());
          this.numOfPages = response.json().num_of_pages;
          this.user = response.json();
          // console.log(this.user);
          this.performData();
        },
        (error) => {
          // console.log(error);
        }
      );
  }

  performData() {
    for (let i = 1; i <= this.numOfPages; i++) {
      this.cs.getGhests(this.gholnameId, i).subscribe(
        (response) => {
          if (i == this.numOfPages) {
            this.dataReadyForShow = true;
          }

          this.fixTo18(response.json().aghsat);
        },
        (error) => {

        }
      );
    }

  }

  fixTo18(ghests) {

    this.gholnameGhestData.push(ghests);

    var leangth = ghests.length;
    var fixto18;

    if (leangth > 18) {
      if (leangth % 18) {
        fixto18 = 18 - leangth % 18;
      }
    } else {
      fixto18 = 18 - leangth;
    }
    for (var i = 1; i <= fixto18; i++) {
      this.gholnameGhestData[this.gholnameGhestData.length - 1].push({});
    }

  }

  setGholnameId() {
    this.gholnameId = this.route.snapshot.params.id;
  }

  ngOnInit() {
    this.setGholnameId();
    this.getGholnameGhests();
  }

}
