import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../../services/connector.service';
import {ActivatedRoute, Router} from '@angular/router';
import {AppService} from '../../../../../../../services/app.service';

@Component({
  selector: 'app-single-sefr-naghdi',
  templateUrl: './single-sefr-naghdi.component.html',
  styleUrls: ['./single-sefr-naghdi.component.css']
})

export class SingleSefrNaghdiComponent implements OnInit {
  public id;
  public gholname;
  public isLoading;

  constructor(public router: Router, public app: AppService, public route: ActivatedRoute, public cs: ConnectorService) {

  }

  setSellerInfo(id) {
    this.gholname.gholname.foro0shande.id = id;
  }

  setManbaaKharid(id) {
    this.gholname.manba_kharid.id = id;
  }


  setBuyerInfo(id) {
    this.gholname.gholname.kharidar.id = id;
  }

  getGholname() {
    this.cs.getGholnameNaghdi(this.id).subscribe(
      (response) => {
        // console.log(response.json());
        this.gholname = response.json();
      },
      (error) => {
        // console.log(error);
      }
    );

  }

  calculateAlbaghi() {
    this.gholname.baghimande = this.app.calcAlbaghi(this.gholname.gholname.total_cost, this.gholname.gholname.pish_pardakht);
  }

  editGholname() {
    this.cs.editGholnameSefrNaghdi(this.gholname).subscribe(
      (response) => {
        // console.log(response.json());
        this.router.navigate(['/gholname/search/'], {queryParams: {}, queryParamsHandling: 'merge'});
      }, (error) => {
        // console.log(error);
      }
    );
  }

  setId() {
    this.id = this.route.snapshot.params.id;
  }

  ngOnInit() {
    this.setId();
    this.getGholname();
  }

}
