import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {MatDialog} from '@angular/material';
import {Router} from '@angular/router';
import {gholnameSefrNaghdi} from '../../../../../../interfaces';
import {NgxPersianNumbersService} from '../../../../../../../../node_modules/ngx-persian-number/src/services/ngx-persian-numbers.service';

@Component({
  selector: 'app-khodro-sefr-naghdi',
  templateUrl: './khodro-sefr-naghdi.component.html',
  styleUrls: ['./khodro-sefr-naghdi.component.css']
})
export class KhodroSefrNaghdiComponent implements OnInit {
  public gholnameSerfNaghdi = new gholnameSefrNaghdi();
  public typeId;
  public systemId;

  constructor(public cs: ConnectorService,
              public ngxNum: NgxPersianNumbersService,
              public dialog: MatDialog,
              public router: Router) {
  }

  public albaghiCost;
  public shomareSanad: any;
  public isLoading;

  getShomareSanad() {
    this.isLoading = true;
    this.cs.getShomare_sanad_jadid().subscribe(
      (response) => {
        this.shomareSanad = response.json().shomare_sanad;
        this.isLoading = false;
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  setTahvilTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameSerfNaghdi.tahvil_datetime = timestamp;

  }

  setGholnameTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameSerfNaghdi.gholname_datetime = timestamp;
  }

  setSellerInfo(id) {
    this.gholnameSerfNaghdi.foro0shande_id = id;
  }

  setManbaaKharid(id) {
    this.gholnameSerfNaghdi.manba_kharid_id = id;
  }


  setBuyerInfo(id) {
    this.gholnameSerfNaghdi.kharidar_id = id;
  }

  calculateAlbaghi() {
    const totalCost = +this.ngxNum.removeLettersFromString(this.gholnameSerfNaghdi.total_cost);
    const pishpardakht = +this.ngxNum.removeLettersFromString(this.gholnameSerfNaghdi.pish_pardakht);
    const remainCost = totalCost - pishpardakht;
    this.albaghiCost = remainCost;
  }

  setKhargSanad(option) {
    this.gholnameSerfNaghdi.kharj_sanad = option.value;
  }

  ngOnInit() {
    this.getShomareSanad();
  }

  createGholnameSerfNaghdi() {
    // console.log(this.gholnameSerfNaghdi);
    this.isLoading = true;
    this.cs.createGholnameSerfNaghdi(this.gholnameSerfNaghdi)
      .subscribe(
        (response) => {
          this.isLoading = false;
          this.router.navigate(['/gholname/naghdi/' + response.json().gholname.id]);
        },
        (error) => {
          this.isLoading = false;
          // console.log(error);
        }
      );
  }
}
