import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../../services/connector.service';
import {ActivatedRoute, Router} from '@angular/router';
import {AppService} from '../../../../../../../services/app.service';

@Component({
  selector: 'app-single-sefr-lizing',
  templateUrl: './single-sefr-lizing.component.html',
  styleUrls: ['./single-sefr-lizing.component.css']
})
export class SingleSefrLizingComponent implements OnInit {
  public id;
  public gholnameData;
  public car;
  public mablaghHarGhest;

  constructor(public app: AppService, public cs: ConnectorService, public route: ActivatedRoute, public router: Router) {
  }


  getGholnameData() {
    this.cs.getGholnameLizing(this.id).subscribe(
      (response) => {
        // console.log(response.json());
        this.gholnameData = response.json();
        this.gholnameData.gholname.id = this.id;
        // console.log(this.gholnameData.gholname.id);
        // console.log(this.gholnameData);
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  editGholname() {
    // console.log(this.gholnameData);
    this.cs.editGholnameLizing(this.gholnameData).subscribe(
      (response) => {
        // console.log(response.json());
        this.router.navigate(['/gholname/search/'], {queryParams: {}, queryParamsHandling: 'merge'});
      }, (error) => {
        // console.log(error);
      }
    );
  }

  calcAlbaghi() {
    this.gholnameData.baghimande = this.app.calcAlbaghi(this.gholnameData.gholname.total_cost, this.gholnameData.gholname.pish_pardakht);
    this.mablaghHarGhest = Number(this.gholnameData.baghimande / Number(this.gholnameData.chek_num));
  }

  setId() {
    this.id = this.route.snapshot.params.id;
  }

  ngOnInit() {
    this.setId();
    this.getGholnameData();
  }
}
