import {Component, OnInit} from '@angular/core';
import {gholnameSefrLizing} from '../../../../../../interfaces';
import {Router} from '@angular/router';
import {ConnectorService} from '../../../../../../services/connector.service';
import {MatDialog} from '@angular/material';
import {NgxPersianNumbersService} from '../../../../../../../../node_modules/ngx-persian-number/src/services/ngx-persian-numbers.service';

@Component({
  selector: 'app-khodro-sefr-lizing',
  templateUrl: './khodro-sefr-lizing.component.html',
  styleUrls: ['./khodro-sefr-lizing.component.css']
})
export class KhodroSefrLizingComponent implements OnInit {
  constructor(public cs: ConnectorService,
              public ngxNum: NgxPersianNumbersService,
              public dialog: MatDialog,
              public router: Router) {
  }

  public gholnameSerfLizing = new gholnameSefrLizing();
  public albaghiCost;
  public shomareSanad: any;
  public isLoading;
  public mablaghHarGhest;
  public typeId;
  public systemId;

  setManbaaKharid(userId) {
    this.gholnameSerfLizing.manba_kharid_id = userId;
  }

  getShomareSanad() {
    this.isLoading = true;
    this.cs.getShomare_sanad_jadid().subscribe(
      (response) => {
        this.shomareSanad = response.json().shomare_sanad;
        this.isLoading = false;
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  setTahvilTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameSerfLizing.tahvil_datetime = timestamp;

  }

  setGholnameTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameSerfLizing.gholname_datetime = timestamp;
  }

  setSellerInfo(id) {
    this.gholnameSerfLizing.foro0shande_id = id;
  }

  setBuyerInfo(id) {
    this.gholnameSerfLizing.kharidar_id = id;
  }

  calculateAlbaghi() {
    const totalCost = +this.ngxNum.removeLettersFromString(this.gholnameSerfLizing.total_cost);
    const pishPardakh = +this.ngxNum.removeLettersFromString(this.gholnameSerfLizing.pish_pardakht);
    const remainCost = totalCost - pishPardakh;

    this.albaghiCost = remainCost;
    this.mablaghHarGhest = Number(remainCost / this.gholnameSerfLizing.chek_num);

    // console.log(this.mablaghHarGhest);

  }

  setKhargSanad(option) {
    this.gholnameSerfLizing.kharj_sanad = option.value;
  }

  createGholnameSerfNaghdi() {
    this.isLoading = true;
    console.log(this.gholnameSerfLizing);
    this.cs.createGholnameSefrLizing(this.gholnameSerfLizing)
      .subscribe(
        (response) => {
          this.isLoading = false;
          console.log(response.json());
          this.router.navigate(['gholname/sefr_lizing/' + response.json().gholname.id]);
        },
        (error) => {
          this.isLoading = false;
          console.log(error);
        }
      );
  }

  ngOnInit() {
    this.getShomareSanad();
  }
}
