import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../../services/connector.service';
import {AppService} from '../../../../../../../services/app.service';
import {ActivatedRoute, Router} from '@angular/router';

@Component({
  selector: 'app-single-serfr-aghsati',
  templateUrl: './single-serfr-aghsati.component.html',
  styleUrls: ['./single-serfr-aghsati.component.css']
})
export class SingleSerfrAghsatiComponent implements OnInit {
  public id;
  public gholname;
  public isLoading;

  constructor(public router: Router, public app: AppService, public route: ActivatedRoute, public cs: ConnectorService) {

  }

  setSellerInfo(id) {
    this.gholname.gholname.foro0shande.id = id;
  }

  setManbaaKharid(id) {
    this.gholname.manba_kharid.id = id;
  }


  setBuyerInfo(id) {
    this.gholname.gholname.kharidar.id = id;
  }

  getGholname() {
    this.cs.getGholnameAghsati(this.id).subscribe(
      (response) => {
        // console.log(response.json());
        this.gholname = response.json();
        console.log(this.gholname);
      },
      (error) => {
        // console.log(error);
      }
    );

  }

  calculateAlbaghi() {
    this.gholname.baghimande = this.app.calcAlbaghi(this.gholname.gholname.total_cost, this.gholname.gholname.pish_pardakht);
    this.clacMablaghGhest();
  }

  editGholname() {
    this.cs.editGholnameSefrAghsati(this.gholname).subscribe(
      (response) => {
        // console.log(response.json());
        this.router.navigate(['/gholname/search/'], {queryParams: {}, queryParamsHandling: 'merge'});
      }, (error) => {
        // console.log(error);
      }
    );
  }

  clacMablaghGhest() {
    this.gholname.mablagh_e_ghest = this.app.calcMablaghGhests(this.gholname.baghimande, this.gholname.num_of_ghest, this.gholname.percent);
  }

  setStartGhests(time) {
    this.gholname.ghest_start_datetime = time;
  }

  setId() {
    this.id = this.route.snapshot.params.id;
  }

  ngOnInit() {
    this.setId();
    this.getGholname();
  }
}
