import {Component, OnInit} from '@angular/core';
import {Router} from '@angular/router';
import {MatDialog} from '@angular/material';
import {ConnectorService} from '../../../../../../services/connector.service';
import {gholnameSefrAghsati} from '../../../../../../interfaces';
import {NgxPersianNumbersService} from '../../../../../../../../node_modules/ngx-persian-number/src/services/ngx-persian-numbers.service';
import {AppService} from '../../../../../../services/app.service';

@Component({
  selector: 'app-khodro-sefr-aghsati',
  templateUrl: './khodro-sefr-aghsati.component.html',
  styleUrls: ['./khodro-sefr-aghsati.component.css']
})
export class KhodroSefrAghsatiComponent implements OnInit {
  public mablaghGhest;
  public typeId;
  public systemId;


  constructor(public cs: ConnectorService,
              public router: Router,
              public ngxNum: NgxPersianNumbersService,
              public app: AppService,
              public dialog: MatDialog) {
  }

  public albaghiCost;
  public gholnameSefrAghsati = new gholnameSefrAghsati();
  public shomareSanad: any;
  public isLoading;

  getShomareSanad() {
    this.isLoading = true;
    this.cs.getShomare_sanad_jadid().subscribe(
      (response) => {
        this.shomareSanad = response.json().shomare_sanad;
        this.isLoading = false;
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  setManbaaKharid(userId) {
    this.gholnameSefrAghsati.manba_kharid_id = userId;
  }

  setStartGhests(time) {
    this.gholnameSefrAghsati.ghest_start_datetime = time;
  }

  setTahvilTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameSefrAghsati.tahvil_datetime = timestamp;
  }

  setShrooAghsat(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameSefrAghsati.ghest_start_datetime = timestamp;
  }

  setGholnameTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameSefrAghsati.gholname_datetime = timestamp;
  }


  calculateAlbaghi() {
    const totalCost = +this.ngxNum.removeLettersFromString(this.gholnameSefrAghsati.total_cost);
    const pishPardakht = +this.ngxNum.removeLettersFromString(this.gholnameSefrAghsati.pish_pardakht);
    this.albaghiCost = totalCost - pishPardakht;
    this.clacMablaghGhest();
  }

  setSellerInfo(id) {
    this.gholnameSefrAghsati.foro0shande_id = id;
  }

  setBuyerInfo(id) {
    this.gholnameSefrAghsati.kharidar_id = id;
    // console.log(this.gholnameSefrAghsati);
  }

  ngOnInit() {
    this.getShomareSanad();
  }

  setKhargSanad(option) {
    this.gholnameSefrAghsati.kharj_sanad = option.value;
    // console.log(this.gholnameSefrAghsati);
  }

  clacMablaghGhest() {
    this.mablaghGhest = this.app.calcMablaghGhests(this.albaghiCost,this.gholnameSefrAghsati.ghest_num,this.gholnameSefrAghsati.percent_num)
  }

  createGholnameSefrAghsati() {
    this.isLoading = true;
    this.cs.createGholnamesefrAghsati(this.gholnameSefrAghsati).subscribe(
      (response) => {
        this.isLoading = false;
        this.router.navigate(['/gholname/aghsati/' + response.json().gholname.id]);
      }, (error) => {
        this.isLoading = false;
        // console.log(error);
      }
    );
  }
}
