import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../../services/connector.service';
import {ActivatedRoute, Router} from '@angular/router';
import {AppService} from '../../../../../../../services/app.service';

@Component({
  selector: 'app-single-kharid-namayeshgah',
  templateUrl: './single-kharid-namayeshgah.component.html',
  styleUrls: ['./single-kharid-namayeshgah.component.css']
})
export class SingleKharidNamayeshgahComponent implements OnInit {
  public gholnameData;
  public id;

  constructor(public router: Router, public cs: ConnectorService, public route: ActivatedRoute, public app: AppService) {
  }

  getGholnameData() {
    this.cs.getGholnameKharidNamayeshgah(this.id).subscribe(
      (response) => {
        this.gholnameData = response.json();
        // console.log(this.gholnameData);
      },
      (error) => {
        // console.log(error);
      }
    );

  }

  editGholname() {
    // console.log(this.gholnameData);
    this.cs.editGholnameKharidNamayeshgah(this.gholnameData).subscribe(
      (response) => {
        // console.log(response);
        this.router.navigate(['/gholname/search/'], {queryParams: {}, queryParamsHandling: 'merge'});
      }, (error) => {
        // console.log(error);
      }
    );

  }

  calcAlbaghi() {
    this.gholnameData.baghimande = this.app.calcAlbaghi(this.gholnameData.gholname.total_cost, this.gholnameData.gholname.pish_pardakht);
  }

  setId() {
    this.id = this.route.snapshot.params.id;
  }

  ngOnInit() {
    this.setId();
    this.getGholnameData();
  }

}

