import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {MatDialog} from '@angular/material';
import {gholnameKharidNamayeshgah} from '../../../../../interfaces';
import {Router} from '@angular/router';
import {NgxPersianNumbersService} from '../../../../../../../node_modules/ngx-persian-number/src/services/ngx-persian-numbers.service';

@Component({
  selector: 'app-kharid-namayeshgah',
  templateUrl: './kharid-namayeshgah.component.html',
  styleUrls: ['./kharid-namayeshgah.component.css']
})
export class KharidNamayeshgahComponent implements OnInit {
  constructor(public cs: ConnectorService, public ngxNum: NgxPersianNumbersService, public dialog: MatDialog, public router: Router) {
  }

  public typeId;
  public systemId;
  public gholnameKharidNamayeshgah = new gholnameKharidNamayeshgah();

  public albaghiCost;
  public shomareSanad: any;
  public isLoading;

  getShomareSanad() {
    this.isLoading = true;
    this.cs.getShomare_sanad_jadid().subscribe(
      (response) => {
        this.shomareSanad = response.json().shomare_sanad;
        this.isLoading = false;
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  setPelak(pelak) {
    this.gholnameKharidNamayeshgah.pelak = pelak;
  }

  setTahvilTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameKharidNamayeshgah.tahvil_datetime = timestamp;

  }

  setGholnameTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameKharidNamayeshgah.gholname_datetime = timestamp;
  }

  setSellerInfo(id) {
    this.gholnameKharidNamayeshgah.foro0shande_id = id;
  }

  setSahebPelakInfo(id) {
    this.gholnameKharidNamayeshgah.saheb_pelak_id = id;
  }


  setBuyerInfo(id) {
    this.gholnameKharidNamayeshgah.kharidar_id = id;
  }

  calculateAlbaghi() {
    const totalCost = +this.ngxNum.removeLettersFromString(this.gholnameKharidNamayeshgah.total_cost);
    const pishpardakht = +this.ngxNum.removeLettersFromString(this.gholnameKharidNamayeshgah.pish_pardakht);

    // console.log(this.gholnameKharidNamayeshgah.total_cost, this.gholnameKharidNamayeshgah.pish_pardakht);
    const remainCost = +totalCost - +pishpardakht;
    // console.log(remainCost);
    this.albaghiCost = remainCost;
  }

  setKhargSanad(option) {
    this.gholnameKharidNamayeshgah.kharj_sanad = option.value;
  }

  ngOnInit() {
    this.getShomareSanad();
  }

  createGholnameKharidNamayeshgah() {
    // console.log(this.gholnameKharidNamayeshgah);
    this.isLoading = true;
    this.cs.createGholnameKharidNamayeshgah(this.gholnameKharidNamayeshgah)
      .subscribe(
        (response) => {
          this.isLoading = false;
          // console.log(response.json());
          this.router.navigate(['gholname/kharid_namayeshgah/' + response.json().gholname.id]);
        },
        (error) => {
          this.isLoading = false;
          // console.log(error);
        }
      );
  }
}
