import {Component, OnInit} from '@angular/core';
import {ActivatedRoute, Router} from '@angular/router';
import {ConnectorService} from '../../../../../../services/connector.service';
import {AppService} from '../../../../../../services/app.service';

@Component({
  selector: 'app-single-kharid-naghdi',
  templateUrl: './single-kharid-naghdi.component.html',
  styleUrls: ['./single-kharid-naghdi.component.css']
})
export class SingleKharidNaghdiComponent implements OnInit {
  public id;
  public gholnameData;
  public car;

  constructor(public app: AppService, public cs: ConnectorService, public route: ActivatedRoute, public router: Router) {
  }


  getGholnameData() {
    this.cs.getGholnameNaghdi(this.id).subscribe(
      (response) => {
        // console.log(response.json());
        this.gholnameData = response.json();
        this.gholnameData.gholname.id = this.id;
        // console.log(this.gholnameData.gholname.id);
        // console.log(this.gholnameData);
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  editGholname() {
    // console.log(this.gholnameData);
    this.cs.editGholnameNaghdi(this.gholnameData).subscribe(
      (response) => {
        // console.log(response.json());
        this.router.navigate(['/gholname/search/'], {queryParams: {}, queryParamsHandling: 'merge'});
      }, (error) => {
        // console.log(error);
      }
    );
  }

  calcAlbaghi() {
    this.gholnameData.baghimande = this.app.calcAlbaghi(this.gholnameData.gholname.total_cost, this.gholnameData.gholname.pish_pardakht);
  }

  setId() {
    this.id = this.route.snapshot.params.id;
  }

  ngOnInit() {
    this.setId();
    this.getGholnameData();
  }


}
