import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {gholnameNaghdi} from '../../../../../interfaces';
import {Router} from '@angular/router';
import {NgxPersianNumbersService} from '../../../../../../../node_modules/ngx-persian-number/src/services/ngx-persian-numbers.service';

@Component({
  selector: 'app-kharid-naghdi',
  templateUrl: './kharid-naghdi.component.html',
  styleUrls: ['./kharid-naghdi.component.css']
})
export class KharidNaghdiComponent implements OnInit {
  constructor(public cs: ConnectorService, public router: Router, public ngxNum: NgxPersianNumbersService) {
  }

  public albaghiCost;
  public ghonameNaghdi = new gholnameNaghdi();
  public shomareSanad: any;
  public isLoading;

  getShomareSanad() {
    this.isLoading = true;
    this.cs.getShomare_sanad_jadid().subscribe(
      (response) => {
        this.shomareSanad = response.json().shomare_sanad;
        this.isLoading = false;
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  setTahvilTime(val) {
    const timestamp = new Date(val).getTime();
    this.ghonameNaghdi.tahvil_datetime = timestamp;
    // console.log(this.ghonameNaghdi);
  }

  setGholnameTime(val) {
    const timestamp = new Date(val).getTime();
    this.ghonameNaghdi.gholname_datetime = timestamp;
    // console.log(this.ghonameNaghdi);
  }

  setCarInfo(id) {
    this.ghonameNaghdi.car_id = id;
  }

  setBuyerInfo(id) {
    this.ghonameNaghdi.kharidar_id = id;
  }

  setSellerInfo(id) {
    this.ghonameNaghdi.foro0shande_id = id;
  }

  calculateAlbaghi() {
    const totalCost = +this.ngxNum.removeLettersFromString(this.ghonameNaghdi.total_cost);
    const pishpardakht = +this.ngxNum.removeLettersFromString(this.ghonameNaghdi.pish_pardakht);
    const remainCost = +totalCost - +pishpardakht;
    this.albaghiCost = remainCost;
  }

  setKhargSanad(option) {
    this.ghonameNaghdi.kharj_sanad = option.value;
  }

  ngOnInit() {
    this.getShomareSanad();
  }

  createGholnameNaghdi() {
    // console.log(this.ghonameNaghdi);
    this.isLoading = true;
    this.cs.createGholnameNaghdi(this.ghonameNaghdi).subscribe(
      (response) => {
        this.isLoading = false;
        this.router.navigate(['/gholname/naghdi/' + response.json().gholname.id]);
      },
      (error) => {
        this.isLoading = false;
        // console.log(error);
      }
    );
  }
}
