import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {ActivatedRoute, Router} from '@angular/router';
import {AppService} from '../../../../../../services/app.service';

@Component({
  selector: 'app-single-kharid-aghsati',
  templateUrl: './single-kharid-aghsati.component.html',
  styleUrls: ['./single-kharid-aghsati.component.css']
})
export class SingleKharidAghsatiComponent implements OnInit {
  public id;
  public gholnameData;
  public numOfPages;

  constructor(public router: Router,
              public cs: ConnectorService,
              public app: AppService,
              public route: ActivatedRoute) {
  }

  getGholnameData() {
    this.cs.getGholnameAghsati(this.id).subscribe(
      (response) => {
        this.gholnameData = response.json();
        this.numOfPages = this.gholnameData.num_of_pages;
        // console.log(this.gholnameData);
      },
      (error) => {
        // console.log(error);
      }
    );

  }


  calcAlbaghi() {
    this.gholnameData.baghimande = this.app.calcAlbaghi(this.gholnameData.gholname.total_cost, this.gholnameData.gholname.pish_pardakht);
    this.calcMablaghGhest();
  }

  calcMablaghGhest() {
    this.gholnameData.mablagh_e_ghest = this.app.calcMablaghGhests(this.gholnameData.baghimande, this.gholnameData.num_of_ghest, this.gholnameData.percent);
  }

  editGholname() {
    this.cs.editGholnameAghsati(this.gholnameData).subscribe(
      (response) => {
        // console.log(response.json());
        this.router.navigate(['/gholname/search/'], {queryParams: {}, queryParamsHandling: 'merge'});
      }, (error) => {
        // console.log(error);
      }
    );
  }

  setId() {
    this.id = this.route.snapshot.params.id;
  }

  ngOnInit() {
    this.setId();
    this.getGholnameData();
  }

}
