import { Component, OnInit } from '@angular/core';
import { MatDialog } from '@angular/material';
import { User, gholnameAghsati, car } from '../../../../../interfaces';
import { ConnectorService } from '../../../../../services/connector.service';
import { Router } from '@angular/router';
import { NgxPersianNumbersService } from '../../../../../../../node_modules/ngx-persian-number/src/services/ngx-persian-numbers.service';
import { AppService } from '../../../../../services/app.service';

@Component({
  selector: 'app-kharid-aghsati',
  templateUrl: './kharid-aghsati.component.html',
  styleUrls: ['./kharid-aghsati.component.css']
})

export class KharidAghsatiComponent implements OnInit {
  constructor(public cs: ConnectorService,
    public router: Router,
    public ngxNum: NgxPersianNumbersService,
    public app: AppService,
    public dialog: MatDialog) {
  }

  public albaghiCost;
  public buyer: any = new User();
  public seller: any = new User();
  public gholnameAghsati = new gholnameAghsati();
  public shomareSanad: any;
  public isLoading;
  public car = new car();

  getShomareSanad() {
    this.isLoading = true;
    this.cs.getShomare_sanad_jadid().subscribe(
      (response) => {
        this.shomareSanad = response.json().shomare_sanad;
        this.isLoading = false;
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  setTahvilTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameAghsati.tahvil_datetime = timestamp;
  }

  setShrooAghsat(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameAghsati.ghest_start_datetime = timestamp;
  }

  setGholnameTime(val) {
    const timestamp = new Date(val).getTime();
    this.gholnameAghsati.gholname_datetime = timestamp;
  }

  calculateAlbaghi() {
    const totalCost = +this.ngxNum.removeLettersFromString(this.gholnameAghsati.total_cost);
    const pishPardakht = +this.ngxNum.removeLettersFromString(this.gholnameAghsati.pish_pardakht);
    this.albaghiCost = totalCost - pishPardakht;
    this.clacMablaghGhest();
  }

  clacMablaghGhest() {
    this.gholnameAghsati.mablagh_e_ghest = this.app.calcMablaghGhests(this.albaghiCost, this.gholnameAghsati.ghest_num, this.gholnameAghsati.percent_num);
  }

  setSellerInfo(id) {
    this.gholnameAghsati.foro0shande_id = id;
  }

  setBuyerInfo(id) {
    // console.log(id);
    this.gholnameAghsati.kharidar_id = id;
    // console.log(this.gholnameAghsati);
  }

  setCarInfo(id) {
    this.gholnameAghsati.car_id = id;
  }

  ngOnInit() {
    this.getShomareSanad();
  }

  setKhargSanad(option) {
    this.gholnameAghsati.kharj_sanad = option.value;
    // console.log(this.gholnameAghsati);
  }

  createGholnameAghsati() {
    this.isLoading = true;
    this.cs.createGholnmaeAghsati(this.gholnameAghsati).subscribe(
      (response) => {
        this.isLoading = false;
        // console.log(response);
        this.router.navigate(['/gholname/aghsati/' + response.json().gholname.id]);
      },
      (error) => {
        this.isLoading = false;
        // console.log(error);
      }
    );
    // console.log(this.gholnameAghsati);
  }
}
