import {Component, Input, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {ActivatedRoute, Router} from '@angular/router';
import {MatDialog} from '@angular/material';

@Component({
  selector: 'app-gholname-list',
  templateUrl: './gholname-list.component.html',
  styleUrls: ['./gholname-list.component.css']
})
export class GholnameListComponent implements OnInit {
  public isLoading;
  public gholnameList = [];
  public numOfPages;
  @Input() searchParams;


  constructor(public cs: ConnectorService, public router: Router, public modal: MatDialog, private ar: ActivatedRoute) {
    // console.log(this.searchParams);
  }

  navigateToPrintPage(id, type, forooshId) {
    if (type.search('sefr') > -1) {
      if (forooshId) {
        id = forooshId;
      }
      this.router.navigate(['/print/' + type + '/' + id]);
    } else {
      this.router.navigate(['/print/' + type + '/' + id]);
    }
  }

  routeToSingleGholname(type, id, forooshId) {
    if (type.search('sefr') > -1) {
      if (forooshId) {
        id = forooshId;
      }
      this.router.navigate(['/gholname/khodro_sefr/' + type + '/edit/' + id], {queryParams: this.searchParams});
    } else {
      this.router.navigate(['/gholname/' + type + '/edit/' + id], {queryParams: this.searchParams});
    }
  }

  getGholnameList() {
    this.isLoading = true;
    this.cs.getGholnameList2(this.searchParams).subscribe(
      (response) => {
        // console.log(response.json());
        this.isLoading = false;
        this.gholnameList = response.json().gholnames;
        this.numOfPages = response.json().num_of_pages;
      },
      (error) => {
        // console.log(error);
      }
    );
  }

  navigateToPrintGhests(id) {
    this.router.navigate(['/print/aghsati/ghests/' + id]);
  }

  changePage(i) {
    this.searchParams.page = i;
    this.getGholnameList();
  }

  ngOnInit() {
    this.getGholnameList();
  }

}
