import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';
import {ActivatedRoute} from '@angular/router';
import {FaskhGholname} from '../../../../../interfaces';
import {AppService} from '../../../../../services/app.service';

@Component({
  selector: 'app-faskh-gholname',
  templateUrl: './faskh-gholname.component.html',
  styleUrls: ['./faskh-gholname.component.css']
})
export class FaskhGholnameComponent implements OnInit {
  constructor(public cs: ConnectorService,
              public app: AppService,
              public route: ActivatedRoute) {
  }

  public faskhData = new FaskhGholname();

  faskhGholname() {
    // console.log(this.faskhData);
    this.cs.faskhGholname(this.faskhData).subscribe(
      (response) => {
        // console.log(response.json());
        this.app.showSnackbar('قولنامه فسخ شد');
      },
      (error) => {
        if (error.json().code == '033') {
          this.app.showSnackbar('ابتدا باید قولنامه فروش فسخ شود');
        }
        // console.log(error);
      }
    );
  }

  setFaskhDate(time) {
    this.faskhData.faskh_datetime = time;
  }

  setSabtDate(time) {
    this.faskhData.sabt_datetime = time;
  }

  setGholnameId() {
    this.faskhData.id = this.route.snapshot.params.id;
  }

  ngOnInit() {
    this.setGholnameId();
  }

}
