import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {ActivatedRoute, Router} from '@angular/router';
import {MatDialog} from '@angular/material';
import {EditArchive} from '../../../../../../interfaces';

@Component({
  selector: 'app-full-details',
  templateUrl: './full-details.component.html',
  styleUrls: ['./full-details.component.css']
})
export class FullDetailsComponent implements OnInit {
  public archiveId;
  public archiveDetails;


  constructor(public router: Router, public cs: ConnectorService, public route: ActivatedRoute, public dialog: MatDialog) {
  }

  getArchiveDetails() {
    this.cs.getArchiveDetails(this.archiveId).subscribe(
      (response) => {
        console.log(response.json());
        this.archiveDetails = response.json();
      },
      (error) => {
        console.log(error);
      }
    );
  }

  ngOnInit() {
    this.route.parent.params.subscribe(
      (params) => {
        this.archiveId = params.id;
        this.getArchiveDetails();
      }
    );

  }

  editArchive() {
    const editParams = new EditArchive();
    editParams.id = this.archiveDetails.id;
    editParams.vakil_id = this.archiveDetails.vakil_id;
    editParams.current_state = this.archiveDetails.current_state;
    editParams.vekalat_kari_engheza = this.archiveDetails.vekalat_kari_engheza;
    editParams.vekalat_foro0sh_engheza = this.archiveDetails.vekalat_foro0sh_engheza;
    editParams.description = this.archiveDetails.description;
    editParams.sanad_dar_rahn_engheza = this.archiveDetails.sanad_dar_rahn_engheza;
    this.cs.editArchive(editParams).subscribe(
      (response) => {
        console.log(response);
        this.router.navigate(['/archives']);
      },
      (error) => {
        console.log(error);
      }
    );
  }
}
