import {Component, OnInit, ViewChild} from '@angular/core';
import {ExitArchive} from '../../../../../../interfaces';
import {ConnectorService} from '../../../../../../services/connector.service';
import {ActivatedRoute, Router} from '@angular/router';
import {AppService} from '../../../../../../services/app.service';

@Component({
  selector: 'app-exit',
  templateUrl: './exit.component.html',
  styleUrls: ['./exit.component.css']
})
export class ExitComponent implements OnInit {
  public exit = new ExitArchive();
  public madarekTahvil;
  public isLoading;
  public user;
  public isExitAvarez;

  constructor(public app: AppService, public router: Router, public cs: ConnectorService, public route: ActivatedRoute) {
  }

  setTahvilGirande(userId) {
    this.exit.tahvil_girande_id = userId;
  }

  setUserProfile(user) {
    this.user = user;
  }

  getMadarekTahvil() {
    this.isLoading = true;
    this.cs.getArchiveDetails(this.exit.id).subscribe(
      (response) => {
        this.isLoading = false;
        this.madarekTahvil = response.json().madarek_tahvili;
        this.exit.avArez_ta = response.json().madarek_tahvili.avArez_ta;
        console.log(this.madarekTahvil);
      }
    );
  }

  resetNeedToReminder() {
    this.exit.need_to_reminder = '';
  }

  setDataTime(dateTime) {
    this.exit.datetime = dateTime;
  }

  setArchiveId() {
    this.route.parent.params.subscribe(
      (params) => {
        console.log(params);
        this.exit.id = params.id;
      }
    );
  }

  setBargasht(time) {
    this.exit.bargasht_ehtemali_datetime = time;
  }

  setAvarezTime(time) {
    this.exit.avArez_ta = time;
  }


  exitArchive() {
    const text = ' سند در تاریخ ' + this.app.mdstimstampToJalali(this.exit.datetime * 1000) + ' تحویل ' + this.user + ' داده شد ';
    this.exit.description = text;
    console.log(this.exit.avArez_ta);
    this.cs.exitArchive(this.exit, this.isExitAvarez).subscribe(
      (response) => {
        this.router.navigate(['archives/' + this.exit.id + '/details']);
        console.log(response.json());
      },
      (error) => {
        console.log(error);
      }
    );
  }

  ngOnInit() {
    this.setArchiveId();
    this.getMadarekTahvil();
  }
}
