import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {EnterArchive} from '../../../../../../interfaces';
import {ActivatedRoute, Router} from '@angular/router';

@Component({
  selector: 'app-enter',
  templateUrl: './enter.component.html',
  styleUrls: ['./enter.component.css']
})
export class EnterComponent implements OnInit {
  public enter = new EnterArchive();
  public madarekTahvil;
  public isLoading;

  constructor(public router: Router, public cs: ConnectorService, public route: ActivatedRoute) {
  }

  getArchiveDetails() {
    this.isLoading = true;
    this.cs.getArchiveDetails(this.enter.id).subscribe(
      (response) => {
        console.log(response.json());
        this.isLoading = false;
        this.madarekTahvil = response.json().madarek_tahvili;
      },
      (error) => {
        console.log(error);
      }
    );
  }

  setTahvilDahandeId(userId) {
    this.enter.tahvil_dahande_id = userId;
  }

  setDataTime(dateTime) {
    this.enter.datetime = dateTime;
  }

  ngOnInit() {
    this.setArchiveId();
    this.getArchiveDetails();
  }

  setArchiveId() {
    this.route.parent.params.subscribe(
      (params) => {
        this.enter.id = params.id;
      }
    );
  }

  setAvarezTime(time) {
    this.enter.avArez_ta = time;
  }

  enterArchive() {
    console.log(this.enter);
    this.cs.enterArchive(this.enter).subscribe(
      (response) => {
        this.router.navigate(['archives/' + this.enter.id + '/details']);
        console.log('archives/' + this.enter.id + '/details');
        console.log(response.json());
      },
      (error) => {
        console.log(error);
      }
    );

  }
}
