import {Component, EventEmitter, OnInit, Output} from '@angular/core';
import {ArchivesSearchParams} from '../../../../../interfaces';
import {MatDialog} from '@angular/material';
import {SearchUsersComponent} from '../../../../shared/templates/search-users/search-users.component';

@Component({
  selector: 'app-search-in-archives',
  templateUrl: './search-in-archives.component.html',
  styleUrls: ['./search-in-archives.component.css']
})
export class SearchInArchivesComponent implements OnInit {
  @Output() onSearched: EventEmitter<any> = new EventEmitter();
  public searchParams = new ArchivesSearchParams();
  public vakilName;
  public typeId;

  constructor(public dialog: MatDialog) {
  }

  openSelectVakil() {
    const modal = this.dialog.open(SearchUsersComponent);
    modal.afterClosed().subscribe(
      (data) => {
        if (data) {
          this.vakilName = data.data.first_name + ' ' + data.data.last_name;
          this.searchParams.vakil_id = data.data.id;
          this.emitSearchParams();
        }
      }
    );
  }

  emitSearchParams() {
    this.onSearched.emit(this.searchParams);
  }

  setEtmamVekalatForosh(time) {
    this.searchParams.etmam_vekalat_foro0sh = time;
    this.emitSearchParams();
  }

  ngOnInit() {
    this.emitSearchParams();
  }

}
