import {Component, OnInit} from '@angular/core';
import {MiscellenousSearchParams} from '../../../../../../../interfaces';
import {ConnectorService} from '../../../../../../../services/connector.service';

@Component({
  selector: 'app-miscellaneous-document-list',
  templateUrl: './miscellaneous-document-list.component.html',
  styleUrls: ['./miscellaneous-document-list.component.css']
})
export class MiscellaneousDocumentListComponent implements OnInit {
  public numOfPages;
  public searchParams = new MiscellenousSearchParams();
  public resultList;

  constructor(public cs: ConnectorService) {
  }

  getMiscellaneousCarList() {
    this.cs.getMiscellaneousList(this.searchParams).subscribe(
      (response) => {
        console.log(response.json());
        this.resultList = response.json();
        this.numOfPages = this.resultList.num_of_pages;
      }, (error) => {
        console.log(error);
      }
    );
  }
  changePage(page) {
    this.searchParams.page = page;
    this.getMiscellaneousCarList();
  }

  ngOnInit() {
    this.searchParams.type = 'typical';
    console.log(this.searchParams);
    this.getMiscellaneousCarList();
  }

}
