import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../../services/connector.service';
import {MiscellenousSearchParams} from '../../../../../../../interfaces';

@Component({
  selector: 'app-miscellaneous-car-list',
  templateUrl: './miscellaneous-car-list.component.html',
  styleUrls: ['./miscellaneous-car-list.component.css']
})
export class MiscellaneousCarListComponent implements OnInit {
  public searchParams = new MiscellenousSearchParams();
  public numOfPages;
  public resultList;

  constructor(public cs: ConnectorService) {
  }

  getMiscellaneousCarList() {
    console.log();
    this.cs.getMiscellaneousList(this.searchParams).subscribe(
      (response) => {
        console.log(response.json());
        this.resultList = response.json();
        this.numOfPages = this.resultList.num_of_pages;
      }, (error) => {
        console.log(error);
      }
    );
  }

  changePage(page) {
    this.searchParams.page = page;
    this.getMiscellaneousCarList();
  }

  ngOnInit() {
    this.searchParams.type = 'car_sanads';
    this.getMiscellaneousCarList();
  }

}
