import { Component, OnInit } from '@angular/core';
import {ActivatedRoute, Router} from '@angular/router';
import {ConnectorService} from '../../../../../../../services/connector.service';

@Component({
  selector: 'app-single-miscellaneous-document',
  templateUrl: './single-miscellaneous-document.component.html',
  styleUrls: ['./single-miscellaneous-document.component.css']
})
export class SingleMiscellaneousDocumentComponent implements OnInit {
  public documentData;
  public docId;

  constructor(public router: Router, public cs: ConnectorService, public route: ActivatedRoute) {
  }

  getDocumentData(){
    this.cs.getMiscellaneousDocument(this.docId).subscribe(
      (response) => {
        this.documentData = response.json();
      },
      (error) => {
        console.log(error);
      }
    );
  }

  setId() {
    this.docId = this.route.snapshot.params.id;
    console.log('############################');
    console.log(this.docId);
  }

  editDocument() {
    this.cs.editMiscellaneousDocument(this.documentData).subscribe(
      (response) => {
        console.log(response);
        this.router.navigate(['/archives/miscellaneous/list/document']);
      }, (error) => {
        console.log(error);
      }
    );
  }

  deleteDocument() {
    this.cs.deleteMiscellaneousDocument(this.documentData).subscribe(
      (response) => {
        console.log(response);
        this.router.navigate(['/archives/miscellaneous/list/document']);
      }, (error) => {
        console.log(error);
      }
    );
  }

  ngOnInit() {
    this.setId();
    this.getDocumentData();
  }

}
