import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {MiscellaneousTypical} from '../../../../../../interfaces';
import {Router} from '@angular/router';

@Component({
  selector: 'app-miscellaneous-documents',
  templateUrl: './miscellaneous-documents.component.html',
  styleUrls: ['./miscellaneous-documents.component.css']
})
export class MiscellaneousDocumentsComponent implements OnInit {
  public archive = new MiscellaneousTypical();

  constructor(public cs: ConnectorService, public router: Router) {
  }

  createArchive() {
    this.cs.createMiscellaneousTypical(this.archive).subscribe(
      (response) => {
        console.log(response.json());
        this.router.navigate(['/archives/miscellaneous/list/document']);
      },
      (error) => {
        console.log(error);
      }
    );

  }

  ngOnInit() {
  }

}
