import { Component, OnInit } from '@angular/core';
import {ConnectorService} from '../../../../../../../services/connector.service';
import {ActivatedRoute, Router} from '@angular/router';

@Component({
  selector: 'app-single-miscellaneous-car-document',
  templateUrl: './single-miscellaneous-car-document.component.html',
  styleUrls: ['./single-miscellaneous-car-document.component.css']
})
export class SingleMiscellaneousCarDocumentComponent implements OnInit {
  public docId;
  public documentData;

  constructor(public router: Router, public cs: ConnectorService, public route: ActivatedRoute) {
  }

  setId(){
    this.docId = this.route.snapshot.params.id;
  }

  getDocumentData() {
    this.cs.getMiscellaneousCarDocument(this.docId).subscribe(
      (response) => {
        this.documentData = response.json();
      },
      (error) => {
        console.log(error);
      }
    );
  }

  editDocument() {
    this.cs.editMiscellaneousCarDocument(this.documentData).subscribe(
      (response) => {
        console.log(response);
        this.router.navigate(['/archives/miscellaneous/list/car']);
      }, (error) => {
        console.log(error);
      }
    );
  }

  deleteDocument() {
    this.cs.deleteMiscellaneousCarDocument(this.documentData).subscribe(
      (response) => {
        console.log(response);
        this.router.navigate(['/archives/miscellaneous/list/car']);
      }, (error) => {
        console.log(error);
      }
    );
  }

  ngOnInit() {
    this.setId();
    this.getDocumentData();
  }

}
