import {Component, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../../services/connector.service';
import {MiscellaneousCar} from '../../../../../../interfaces';
import {Router} from '@angular/router';
@Component({
  selector: 'app-miscellaneous-car',
  templateUrl: './miscellaneous-car.component.html',
  styleUrls: ['./miscellaneous-car.component.css']
})
export class MiscellaneousCarComponent implements OnInit {
  public archive = new MiscellaneousCar();

  constructor(public cs: ConnectorService, public router: Router) {
  }

  ngOnInit() {
  }

  setAvarezTime(time) {
    this.archive.avArez_ta = time;
  }

  setDataTime(time) {
    this.archive.enter_datetime = time;
  }

  createArchive() {
    console.log(this.archive);
    this.cs.createMiscellaneusCar(this.archive).subscribe(
      (response) => {
        console.log(response);
        this.router.navigate(['/archives/miscellaneous/list/car']);
      }, (error) => {
        console.log(error);
      }
    );
  }
}
