import {Component, OnInit} from '@angular/core';
import {Archive} from '../../../../../interfaces';
import {ConnectorService} from '../../../../../services/connector.service';
import {SelectArchiveComponent} from '../../../../shared/templates/select-archive/select-archive.component';
import {MatDialog} from '@angular/material';
import {Router} from '@angular/router';

@Component({
  selector: 'app-create-new-archive',
  templateUrl: './create-new-archive.component.html',
  styleUrls: ['./create-new-archive.component.css']
})
export class CreateNewArchiveComponent implements OnInit {
  public archive = new Archive();
  public archiveDetails = new Archive();

  constructor(public router: Router, public cs: ConnectorService, public dialog: MatDialog) {
  }

  setRahnEngheza(time) {
    this.archiveDetails.sanad_dar_rahn_engheza = time;
  }

  setDataTime(time) {
    this.archiveDetails.enter_datetime = time;
  }

  openSelectArchive() {
    const modal = this.dialog.open(SelectArchiveComponent, {minWidth: '600px'});
    modal.afterClosed().subscribe(
      (data) => {
        console.log(data);
        if (data) {
          this.archiveDetails = data;
        }
      }
    );
  }

  createArchive() {
    this.cs.createArchive(this.archiveDetails).subscribe(
      (response) => {
        console.log(response.json());
        this.router.navigate(['/archives']);
      },
      (error) => {
        console.log(error);
      }
    );
  }

  ngOnInit() {
  }

}
