import {Component, Input, OnInit} from '@angular/core';
import {ConnectorService} from '../../../../../services/connector.service';

@Component({
  selector: 'app-arichives-list',
  templateUrl: './arichives-list.component.html',
  styleUrls: ['./arichives-list.component.css']
})
export class ArichivesListComponent implements OnInit {
  public archivesList;
  public numOfPages;
  public isLoading;
  @Input() searchParams;

  constructor(public cs: ConnectorService) {
  }

  setPage(page) {
    this.searchParams.page = page;
    this.getArichivesList(this.searchParams);
  }

  getArichivesList(searchParams) {
    this.isLoading = true;
    console.log(this.searchParams);
    this.cs.getArchivesList(searchParams).subscribe(
      (response) => {
        console.log(response.json());
        this.archivesList = response.json().baygani;
        this.numOfPages = response.json().num_of_pages;
        this.isLoading = false;
        console.log(this.archivesList);
      },
      (error) => {
        console.log(error);
      }
    );
  }

  ngOnInit() {
    this.getArichivesList(this.searchParams);
  }
}
