import {Component, OnInit} from '@angular/core';
import {ActivatedRoute} from '@angular/router';
import {ConnectorService} from '../../../../services/connector.service';

@Component({
  selector: 'app-raypo-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.css']
})

export class LoginComponent implements OnInit {
  public userName;
  public password;
  public errorText: any;
  private _next: any;
  public isLoading;

  constructor(public cs: ConnectorService,
              public route: ActivatedRoute,
  ) {
  }

  login() {
    this.isLoading = true;
    this.cs.login(this.userName, this.password).subscribe(
      (response) => {

        console.log(response.json());
        localStorage.setItem('token', response.json().token);
        this.isLoading = false;
        location.href = '/';
      },
      (error) => {
        console.log(error.json());
      }
    );
  }

  setLastRoute() {
    this.route.queryParams.subscribe(
      (params) => {
        if (params.next) {
          this._next = params.next;
        } else {
          this._next = '/';
        }
      });
  }


  ngOnInit() {
    this.setLastRoute();
  }

}
