import {BrowserModule} from '@angular/platform-browser';
import {NgModule} from '@angular/core';
import {MaterialModule} from './modules/material/material.module';
import {AppComponent} from './app.component';
import {RouterModule, Routes} from '@angular/router';
import {FormsModule, ReactiveFormsModule} from '@angular/forms';
import {BrowserAnimationsModule} from '@angular/platform-browser/animations';
import {SideNavContentComponent} from './components/shared/templates/side-nav-content/side-nav-content.component';
import {raypoAuthModule} from '../../node_modules/raypo-ngmaterial-auth-business/raypo-auth.module';
import {LoginComponent} from './components/pages/auth/login/login.component';
import {LogoutComponent} from './components/pages/auth/logout/logout.component';
import {AuthComponent} from './components/pages/auth/auth.component';
import {PanelComponent} from './components/pages/panel/panel.component';
import {AuthGuard} from './guards/auth.guard';
import {ConnectorService} from './services/connector.service';
import {BusinessNavbarComponent} from './components/shared/common/business-navbar-menu/business-navbar.component';
import {AppService} from './services/app.service';
import {TimeStampToJalaiPipe} from './pipes/time-stamp-to-jalai.pipe';
import {HttpClientModule} from '@angular/common/http';
import {LoadingComponent} from './components/shared/common/loading/loading.component';
import {NgxPersianNumbersService} from '../../node_modules/ngx-persian-number/src/services/ngx-persian-numbers.service';
import {GholnameComponent} from './components/pages/panel/gholname/gholname.component';
import {KharidNamayeshgahComponent} from './components/pages/panel/gholname/kharid-namayeshgah/kharid-namayeshgah.component';
import {KharidAghsatiComponent} from './components/pages/panel/gholname/kharid-aghsati/kharid-aghsati.component';
import {KharidNaghdiComponent} from './components/pages/panel/gholname/kharid-naghdi/kharid-naghdi.component';
import {SearchUsersComponent} from './components/shared/templates/search-users/search-users.component';
import {DpDatePickerModule} from 'ng2-jalali-date-picker';
import {MaterialDateTimePickerFiledComponent} from './components/shared/common/material-date-time-picker-filed/material-date-time-picker-filed.component';
import {SelectcarComponent} from './components/shared/templates/selectcar/selectcar.component';
import {PrintKharidAghsatiComponent} from './components/pages/panel/gholname/print-gholname/print-kharid-aghsati/print-kharid-aghsati.component';
import {PrintKharidNaghdiComponent} from './components/pages/panel/gholname/print-gholname/print-kharid-naghdi/print-kharid-naghdi.component';
import {PrintKharidNamayeshgahComponent} from './components/pages/panel/gholname/print-gholname/print-kharid-namayeshgah/print-kharid-namayeshgah.component';
import {PaginationComponent} from './components/shared/common/pagination/pagination.component';
import {ShowSelectedUserComponent} from './components/shared/templates/show-selected-user/show-selected-user.component';
import {PrintGholnameComponent} from './components/pages/panel/gholname/print-gholname/print-gholname.component';
import {CreateUserComponent} from './components/pages/panel/users/create-user/create-user.component';
import {UsersComponent} from './components/pages/panel/users/users.component';
import {UserListComponent} from './components/pages/panel/users/user-list/user-list.component';
import {SingleUserComponent} from './components/pages/panel/users/single-user/single-user.component';
import {SearchInGholnameComponent} from './components/pages/panel/gholname/search-in-gholname/search-in-gholname.component';
import {FaskhGholnameComponent} from './components/pages/panel/gholname/faskh-gholname/faskh-gholname.component';
import {KhodroSefrComponent} from './components/pages/panel/gholname/khodro-sefr/khodro-sefr.component';
import {KhodroSefrLizingComponent} from './components/pages/panel/gholname/khodro-sefr/khodro-sefr-lizing/khodro-sefr-lizing.component';
import {KhodroSefrAghsatiComponent} from './components/pages/panel/gholname/khodro-sefr/khodro-sefr-aghsati/khodro-sefr-aghsati.component';
import {KhodroSefrNaghdiComponent} from './components/pages/panel/gholname/khodro-sefr/khodro-sefr-naghdi/khodro-sefr-naghdi.component';
import {GholnameListComponent} from './components/pages/panel/gholname/gholname-list/gholname-list.component';
import {ShowSelectedCarComponent} from './components/shared/templates/show-selected-car/show-selected-car.component';
import {PrintGholnameAghsatiGhestsComponent} from './components/pages/panel/gholname/print-gholname/print-kharid-aghsati/print-gholname-aghsati-ghests/print-gholname-aghsati-ghests.component';
import {ParkingComponent} from './components/pages/panel/parking/parking.component';
import {SearchInParkingsCarsComponent} from './components/pages/panel/parking/search-in-parkings-cars/search-in-parkings-cars.component';
import {ParkingCarsListComponent} from './components/pages/panel/parking/parking-cars-list/parking-cars-list.component';
import {SingleCarComponent} from './components/pages/panel/parking/single-car/single-car.component';
import {ExpensesComponent} from './components/pages/panel/parking/expenses/expenses.component';
import {CarColorInformationComponent} from './components/pages/panel/parking/car-color-information/car-color-information.component';
import {ArchivesComponent} from './components/pages/panel/archives/archives.component';
import {ArichivesListComponent} from './components/pages/panel/archives/arichives-list/arichives-list.component';
import {MiscellaneousComponent} from './components/pages/panel/archives/miscellaneous/miscellaneous.component';
import {MiscellaneousDocumentsComponent} from './components/pages/panel/archives/miscellaneous/miscellaneous-documents/miscellaneous-documents.component';
import {MiscellaneousCarComponent} from './components/pages/panel/archives/miscellaneous/miscellaneous-car/miscellaneous-car.component';
import {SingleArchiveComponent} from './components/pages/panel/archives/single-archive/single-archive.component';
import {FullDetailsComponent} from './components/pages/panel/archives/single-archive/full-details/full-details.component';
import {EnterComponent} from './components/pages/panel/archives/single-archive/enter/enter.component';
import {ExitComponent} from './components/pages/panel/archives/single-archive/exit/exit.component';
import {SearchInArchivesComponent} from './components/pages/panel/archives/search-in-archives/search-in-archives.component';
import {MiscellaneousListComponent} from './components/pages/panel/archives/miscellaneous/miscellaneous-list/miscellaneous-list.component';
import {CreateMiscellaneousComponent} from './components/pages/panel/archives/miscellaneous/create-miscellaneous/create-miscellaneous.component';
import {CreateNewArchiveComponent} from './components/pages/panel/archives/create-new-archive/create-new-archive.component';
import {SelectArchiveComponent} from './components/shared/templates/select-archive/select-archive.component';
import {MiscellaneousCarListComponent} from './components/pages/panel/archives/miscellaneous/miscellaneous-list/miscellaneous-car-list/miscellaneous-car-list.component';
import {MiscellaneousDocumentListComponent} from './components/pages/panel/archives/miscellaneous/miscellaneous-list/miscellaneous-document-list/miscellaneous-document-list.component';
import {PelakComponent} from './components/shared/common/forms/pelak/pelak.component';
import {PrintLizingComponent} from './components/pages/panel/gholname/print-gholname/print-lizing/print-lizing.component';
import {ParkingHistoryComponent} from './components/pages/panel/parking/parking-history/parking-history.component';
import {ParkingHistoryListComponent} from './components/pages/panel/parking/parking-history/parking-history-list/parking-history-list.component';
import {SelectTypeComponent} from './components/shared/templates/car/select-type/select-type.component';
import {SelectSystemComponent} from './components/shared/templates/car/select-system/select-system.component';
import {SelectTipComponent} from './components/shared/templates/car/select-tip/select-tip.component';
import {SelectColorsComponent} from './components/shared/templates/car/select-colors/select-colors.component';
import {SingleGholnameComponent} from './components/pages/panel/gholname/single-gholname/single-gholname.component';
import {NgxPersianNumberModule} from '../../node_modules/ngx-persian-number/src/ngx-persian-number.module';
import {ShomareDastiComponent} from './components/shared/common/forms/shomare-dasti/shomare-dasti.component';
import {SingleKharidNaghdiComponent} from './components/pages/panel/gholname/kharid-naghdi/single-kharid-naghdi/single-kharid-naghdi.component';
import {SingleKharidAghsatiComponent} from './components/pages/panel/gholname/kharid-aghsati/single-kharid-aghsati/single-kharid-aghsati.component';
import {SingleSefrLizingComponent} from './components/pages/panel/gholname/khodro-sefr/khodro-sefr-lizing/single-sefr-lizing/single-sefr-lizing.component';
import {PelakPipe} from './pipes/pelak.pipe';
import {AutoTabDirective} from './directives/auto-tab.directive';
import {SingleSerfrAghsatiComponent} from './components/pages/panel/gholname/khodro-sefr/khodro-sefr-aghsati/single-serfr-aghsati/single-serfr-aghsati.component';
import {SingleSefrNaghdiComponent} from './components/pages/panel/gholname/khodro-sefr/khodro-sefr-naghdi/single-sefr-naghdi/single-sefr-naghdi.component';
import {SingleKharidNamyeshgahSefrNaghdiComponent} from './components/pages/panel/gholname/kharid-namayeshgah/single/single-kharid-namyeshgah-sefr-naghdi/single-kharid-namyeshgah-sefr-naghdi.component';
import {SingleKharidNamyeshgahSefrAghsatiComponent} from './components/pages/panel/gholname/kharid-namayeshgah/single/single-kharid-namyeshgah-sefr-aghsati/single-kharid-namyeshgah-sefr-aghsati.component';
import {SingleKharidNamyeshgahSefrLizingComponent} from './components/pages/panel/gholname/kharid-namayeshgah/single/single-kharid-namyeshgah-sefr-lizing/single-kharid-namyeshgah-sefr-lizing.component';
import {SingleKharidNamayeshgahComponent} from './components/pages/panel/gholname/kharid-namayeshgah/single/single-kharid-namayeshgah/single-kharid-namayeshgah.component';
import {FaskhInfoComponent} from './components/shared/common/faskh-info/faskh-info.component';
import {FaskhStickerComponent} from './components/shared/common/faskh-sticker/faskh-sticker.component';
import {ShomareBayganiComponent} from './components/pages/panel/archives/shared/shomare-baygani/shomare-baygani.component';
import {PrintComponent} from './components/pages/panel/gholname/print-gholname/print/print.component';
import {SingleMiscellaneousDocumentComponent} from './components/pages/panel/archives/miscellaneous/miscellaneous-documents/single-miscellaneous-document/single-miscellaneous-document.component';
import {SingleMiscellaneousCarDocumentComponent} from './components/pages/panel/archives/miscellaneous/miscellaneous-car/single-miscellaneous-car-document/single-miscellaneous-car-document.component';
import {HesabdariComponent} from './components/pages/panel/hesabdari/hesabdari.component';
import {DaryaftAzTarafHesabComponent} from './components/pages/panel/hesabdari/daryaft-az-taraf-hesab/daryaft-az-taraf-hesab.component';
import {PardakhtBeTarafHesabComponent} from './components/pages/panel/hesabdari/pardakht-be-taraf-hesab/pardakht-be-taraf-hesab.component';
import {SelectCheckComponent} from './components/pages/panel/hesabdari/select-check/select-check.component';
import {MatFormFieldModule, MatInputModule, MatTableModule} from '@angular/material';
import {SandoghComponent} from './components/pages/panel/hesabdari/sandogh/sandogh.component';
import {BankTransactionsComponent} from './components/pages/panel/hesabdari/bank-transactions/bank-transactions.component';
import {AccountsAndCheksComponent} from './components/pages/panel/hesabdari/accounts-and-cheks/accounts-and-cheks.component';
import {AddAccountComponent} from './components/pages/panel/hesabdari/accounts-and-cheks/add-account/add-account.component';
import {EditAccountComponent} from './components/pages/panel/hesabdari/accounts-and-cheks/edit-account/edit-account.component';
import {HesabDaftariComponent} from './components/pages/panel/hesabdari/hesab-daftari/hesab-daftari.component';
import {PrintHesabDaftariComponent} from './components/pages/panel/hesabdari/hesab-daftari/print-hesab-daftari/print-hesab-daftari.component';
import {DaftarChekComponent} from './components/pages/panel/hesabdari/daftar-chek/daftar-chek.component';
import {TalabkarComponent} from './components/pages/panel/hesabdari/talabkar/talabkar.component';
import {BedehkarComponent} from './components/pages/panel/hesabdari/bedehkar/bedehkar.component';
import {DaftarKolComponent} from './components/pages/panel/hesabdari/daftar-kol/daftar-kol.component';
import {AddDaftarKolComponent} from './components/pages/panel/hesabdari/daftar-kol/add-daftar-kol/add-daftar-kol.component';
import {TarifeBankComponent} from './components/pages/panel/hesabdari/tarife-bank/tarife-bank.component';
import {PrintDaftarKolComponent} from './components/pages/panel/hesabdari/daftar-kol/print-daftar-kol/print-daftar-kol.component';
import {PrintCheckhayeSadereComponent} from './components/pages/panel/hesabdari/daftar-chek/print-checkhaye-sadere/print-checkhaye-sadere.component';
import {AshkhasComponent} from './components/pages/panel/hesabdari/ashkhas/ashkhas.component';
import {EditAshkhasComponent} from './components/pages/panel/hesabdari/ashkhas/edit-ashkhas/edit-ashkhas.component';
import {AcceptEditComponent} from './components/pages/panel/hesabdari/ashkhas/edit-ashkhas/accept-edit/accept-edit.component';
import {DaftarRouzaneComponent} from './components/pages/panel/hesabdari/daftar-rouzane/daftar-rouzane.component';
import {BanksComponent} from './components/pages/panel/hesabdari/banks/banks.component';
import {DaftarChekListComponent} from './components/pages/panel/hesabdari/daftar-chek-list/daftar-chek-list.component';
import {DhesabKolComponent} from './components/pages/panel/hesabdari/dhesab-kol/dhesab-kol.component';
import {AmaliatBankiComponent} from 'app/components/pages/panel/hesabdari/amaliat-banki/amaliat-banki.component';
import {SearchBankComponent} from './components/shared/templates/search-bank/search-bank.component';
import {DaftarKolDetailComponent} from './components/pages/panel/hesabdari/daftar-kol-detail/daftar-kol-detail.component';
import { ChekDialogComponent } from './components/pages/panel/hesabdari/chek-dialog/chek-dialog.component';
import { DailyComponent } from './components/pages/panel/hesabdari/daily/daily.component';

const appRoutes: Routes = [
  {
    path: '',
    component: PanelComponent,
    canActivate: [AuthGuard],
    children: [
      {
        path: 'users',
        children: [
          {
            path: '',
            component: UsersComponent
          },
          {
            path: 'create',
            component: CreateUserComponent
          },
          {
            path: 'list',
            component: UserListComponent
          },
          {
            path: ':id',
            component: SingleUserComponent
          }
        ]
      },
      {
        path: 'archives',
        children: [
          {
            path: '',
            component: ArchivesComponent,
          },
          {
            path: 'create',
            component: CreateNewArchiveComponent
          },

          {
            path: 'miscellaneous',
            children: [
              {
                path: '',
                component: MiscellaneousComponent
              },
              {
                path: 'create',
                component: CreateMiscellaneousComponent,
                children: [
                  {
                    path: 'car',
                    component: MiscellaneousCarComponent
                  },
                  {
                    path: 'documents',
                    component: MiscellaneousDocumentsComponent
                  }
                ]
              },
              {
                path: 'list',
                children: [
                  {
                    path: '',
                    component: MiscellaneousListComponent
                  },
                  {
                    path: 'car',
                    component: MiscellaneousCarListComponent
                  },
                  {
                    path: 'document',
                    component: MiscellaneousDocumentListComponent,
                  },
                  {
                    path: 'document/:id',
                    component: SingleMiscellaneousDocumentComponent
                  },
                  {
                    path: 'car/:id',
                    component: SingleMiscellaneousCarDocumentComponent
                  }
                ]
              }
            ]
          },
          {
            path: ':id',
            component: SingleArchiveComponent,
            children: [
              {
                path: '',
                pathMatch: 'full',
                redirectTo: 'details'
              },
              {
                path: 'details',
                component: FullDetailsComponent
              },
              {
                path: 'enter',
                component: EnterComponent
              },
              {
                path: 'exit',
                component: ExitComponent
              }
            ]
          },
        ]
      },
      {
        path: 'parking',
        children: [
          {
            path: '',
            component: ParkingComponent
          },
          {
            path: 'list',
            component: SearchInParkingsCarsComponent
          },
          {
            path: 'history',
            component: ParkingHistoryComponent
          },
          {
            path: 'car/:id',
            component: SingleCarComponent
          }
        ]
      },
      {
        path: 'gholname',
        children: [
          {
            path: '',
            component: GholnameComponent,
          },
          {
            path: 'kharid_namayeshgah',
            children: [
              {
                path: '',
                component: KharidNamayeshgahComponent
              },
              {
                path: 'edit/:id',
                component: SingleKharidNamayeshgahComponent
              }
            ]
          },
          {
            path: 'naghdi',
            children: [
              {
                path: '',
                component: KharidNaghdiComponent,
              },
              {
                path: 'edit/:id',
                component: SingleKharidNaghdiComponent
              }
            ]
          },
          {
            path: 'aghsati',
            children: [
              {
                path: '',
                component: KharidAghsatiComponent
              },
              {
                path: 'edit/:id',
                component: SingleKharidAghsatiComponent
              }
            ]
          },
          {
            path: 'search',
            component: SearchInGholnameComponent
          },
          {
            path: 'faskh/:id',
            component: FaskhGholnameComponent
          },

          {
            path: 'khodro_sefr',
            children: [
              {
                path: '',
                component: KhodroSefrComponent
              },
              {
                path: 'sefr_aghsati',
                children: [
                  {
                    path: '',
                    component: KhodroSefrAghsatiComponent,
                  },
                  {
                    path: 'edit/:id',
                    component: SingleSerfrAghsatiComponent
                  }
                ]
              },
              {
                path: 'sefr_lizing',
                children: [
                  {
                    path: '',
                    component: KhodroSefrLizingComponent,
                  },
                  {
                    path: 'edit/:id',
                    component: SingleSefrLizingComponent
                  }
                ]
              },
              {
                path: 'sefr_naghdi',
                children: [
                  {
                    path: '',
                    component: KhodroSefrNaghdiComponent
                  },
                  {
                    path: 'edit/:id',
                    component: SingleSefrNaghdiComponent
                  }
                ]
              }
            ]
          },
          {
            path: ':type/:id',
            component: SingleGholnameComponent
          }
        ]
      },
      {
        path: 'hesabdari',
        children: [
          {
            path: '',
            component: HesabdariComponent
          },
          {
            path: 'daryaft-az-taraf-hesab',
            component: DaryaftAzTarafHesabComponent
          },
          {
            path: 'pardakht-be-taraf-hesab',
            component: PardakhtBeTarafHesabComponent
          },
          {
            path: 'talabkar',
            component: TalabkarComponent
          },
          {
            path: 'bedehkar',
            component: BedehkarComponent
          },
          {
            path: 'sandogh',
            component: SandoghComponent
          },
          {
            path: 'bank-transactions',
            component: BankTransactionsComponent
          },
          {
            path: 'accounts-and-cheks',
            component: AccountsAndCheksComponent
          },
          {
            path: 'hesab-daftari',
            component: HesabDaftariComponent
          },
          {
            path: 'daftar-rozane',
            component: DailyComponent,
          },
          {
            path: 'daftare-chek',
            component: DaftarChekComponent
          },
          {
            path: 'daftare-kol',
            children: [
              {
                path: '',
                component: DaftarKolComponent
              },
              {
                path: ':id',
                component: DaftarKolDetailComponent
              }
            ]
          },
          {
            path: 'tarife-bank',
            component: TarifeBankComponent
          },
          {
            path: 'ashkhas',
            component: AshkhasComponent
          },
        ]
      }
    ]
  },
  {
    path: 'print',
    children: [
      {
        path: 'check-sadere',
        component: PrintCheckhayeSadereComponent
      },
      {
        path: 'print-daftari',
        component: PrintHesabDaftariComponent,
      },
      {
        path: 'print-daftar-kol',
        component: PrintDaftarKolComponent
      },
      {
        path: 'naghdi/:id',
        component: PrintKharidNaghdiComponent
      },
      {
        path: 'sefr_aghsati/:id',
        component: PrintKharidAghsatiComponent
      },
      {
        path: 'sefr_naghdi/:id',
        component: PrintKharidNaghdiComponent
      },
      {
        path: 'sefr_lizing/:id',
        component: PrintLizingComponent
      },
      {
        path: 'aghsati',
        children: [
          {
            path: 'ghests/:id',
            component: PrintGholnameAghsatiGhestsComponent
          },
          {
            path: ':id',
            component: PrintKharidAghsatiComponent,
          },
        ]
      },
      {
        path: 'kharid_namayeshgah/:id',
        component: PrintKharidNamayeshgahComponent
      }
    ]
  },
  {
    path: 'user',
    component: AuthComponent,
    children: [
      {
        path: 'login',
        component: LoginComponent,
      }, {
        path: 'logout',
        component: LogoutComponent,
      }
    ]
  },
];

@NgModule({
  declarations: [
    AppComponent,
    SideNavContentComponent,
    LoginComponent,
    LogoutComponent,
    AuthComponent,
    PanelComponent,
    BusinessNavbarComponent,
    TimeStampToJalaiPipe,
    LoadingComponent,
    GholnameComponent,
    KharidNamayeshgahComponent,
    KharidAghsatiComponent,
    KharidNaghdiComponent,
    SearchUsersComponent,
    MaterialDateTimePickerFiledComponent,
    SelectcarComponent,
    PrintKharidAghsatiComponent,
    PrintKharidNaghdiComponent,
    PrintKharidNamayeshgahComponent,
    PaginationComponent,
    ShowSelectedUserComponent,
    PrintGholnameComponent,
    CreateUserComponent,
    UsersComponent,
    UserListComponent,
    SingleUserComponent,
    SearchInGholnameComponent,
    FaskhGholnameComponent,
    KhodroSefrComponent,
    KhodroSefrLizingComponent,
    KhodroSefrAghsatiComponent,
    KhodroSefrNaghdiComponent,
    GholnameListComponent,
    ShowSelectedCarComponent,
    PrintGholnameAghsatiGhestsComponent,
    ParkingComponent,
    SearchInParkingsCarsComponent,
    ParkingCarsListComponent,
    SingleCarComponent,
    ExpensesComponent,
    CarColorInformationComponent,
    ArchivesComponent,
    ArichivesListComponent,
    MiscellaneousComponent,
    MiscellaneousDocumentsComponent,
    MiscellaneousCarComponent,
    SingleArchiveComponent,
    FullDetailsComponent,
    EnterComponent,
    ExitComponent,
    SearchInArchivesComponent,
    MiscellaneousListComponent,
    CreateMiscellaneousComponent,
    CreateNewArchiveComponent,
    SelectArchiveComponent,
    MiscellaneousCarListComponent,
    MiscellaneousDocumentListComponent,
    PelakComponent,
    PrintLizingComponent,
    ParkingHistoryComponent,
    ParkingHistoryListComponent,
    SelectTypeComponent,
    SelectSystemComponent,
    SelectTipComponent,
    SelectColorsComponent,
    SingleGholnameComponent,
    ShomareDastiComponent,
    SingleKharidNaghdiComponent,
    SingleKharidAghsatiComponent,
    SingleKharidNamayeshgahComponent,
    SingleSefrLizingComponent,
    PelakPipe,
    AutoTabDirective,
    SingleSerfrAghsatiComponent,
    SingleSefrNaghdiComponent,
    SingleKharidNamyeshgahSefrNaghdiComponent,
    SingleKharidNamyeshgahSefrAghsatiComponent,
    SingleKharidNamyeshgahSefrLizingComponent,
    FaskhInfoComponent,
    FaskhStickerComponent,
    ShomareBayganiComponent,
    PrintComponent,
    SingleMiscellaneousDocumentComponent,
    SingleMiscellaneousCarDocumentComponent,
    HesabdariComponent,
    DaryaftAzTarafHesabComponent,
    PardakhtBeTarafHesabComponent,
    SelectCheckComponent,
    SandoghComponent,
    BankTransactionsComponent,
    AccountsAndCheksComponent,
    AddAccountComponent,
    EditAccountComponent,
    HesabDaftariComponent,
    PrintHesabDaftariComponent,
    DaftarChekComponent,
    TalabkarComponent,
    BedehkarComponent,
    DaftarKolComponent,
    AddDaftarKolComponent,
    TarifeBankComponent,
    PrintDaftarKolComponent,
    PrintCheckhayeSadereComponent,
    AshkhasComponent,
    EditAshkhasComponent,
    AcceptEditComponent,
    DaftarRouzaneComponent,
    BanksComponent,
    DaftarChekListComponent,
    DhesabKolComponent,
    AmaliatBankiComponent,
    SearchBankComponent,
    DaftarKolDetailComponent,
    ChekDialogComponent,
    DailyComponent,
  ],
  imports: [
    BrowserModule,
    MaterialModule,
    MatFormFieldModule,
    MatInputModule,
    RouterModule.forRoot(
      appRoutes
    ),
    FormsModule,
    BrowserAnimationsModule,
    raypoAuthModule,
    HttpClientModule,
    DpDatePickerModule,
    ReactiveFormsModule,
    NgxPersianNumberModule,
    MatTableModule
  ],
  providers: [
    AppService,
    AuthGuard,
    NgxPersianNumbersService,
    ConnectorService],
  entryComponents: [
    SearchUsersComponent,
    SelectcarComponent,
    SelectArchiveComponent,
    FaskhGholnameComponent,
    SelectCheckComponent,
    AddAccountComponent,
    EditAccountComponent,
    AddDaftarKolComponent,
    EditAshkhasComponent,
    SearchBankComponent,
    AcceptEditComponent,
    ChekDialogComponent
  ],
  bootstrap: [AppComponent]
})

export class AppModule {
}
