import { CommandDefinition } from './command_definition';
export declare let getNetworkConnection: CommandDefinition<number>;
export declare let setNetworkConnection: CommandDefinition<void>;
export declare let toggleAirplaneMode: CommandDefinition<void>;
export declare let toggleWiFi: CommandDefinition<void>;
export declare let toggleData: CommandDefinition<void>;
export declare let toggleLocationServices: CommandDefinition<void>;
export declare let getGeolocation: CommandDefinition<{
    latitude: number;
    longitude: number;
    altitude: number;
}>;
export declare let setGeolocation: CommandDefinition<void>;
export declare let getCurrentDeviceActivity: CommandDefinition<string>;
export declare let startDeviceActivity: CommandDefinition<void>;
export declare let getAppiumSettings: CommandDefinition<{
    [name: string]: any;
}>;
export declare let setAppiumSettings: CommandDefinition<void>;
export declare let getCurrentContext: CommandDefinition<string>;
export declare let selectContext: CommandDefinition<void>;
export declare let getScreenOrientation: CommandDefinition<"LANDSCAPE" | "PORTRAIT">;
export declare let setScreenOrientation: CommandDefinition<void>;
export declare let isDeviceLocked: CommandDefinition<boolean>;
export declare let lockDevice: CommandDefinition<void>;
export declare let unlockDevice: CommandDefinition<void>;
export declare let installApp: CommandDefinition<void>;
export declare let isAppInstalled: CommandDefinition<boolean>;
export declare let removeApp: CommandDefinition<void>;
export declare let pullFileFromDevice: CommandDefinition<string>;
export declare let pullFolderFromDevice: CommandDefinition<any>;
export declare let pushFileToDevice: CommandDefinition<void>;
export declare let listContexts: CommandDefinition<string[]>;
export declare let uploadFile: CommandDefinition<void>;
export declare let switchToParentFrame: CommandDefinition<void>;
export declare let fullscreen: CommandDefinition<void>;
export declare let sendAppToBackground: CommandDefinition<void>;
export declare let closeApp: CommandDefinition<void>;
export declare let getAppStrings: CommandDefinition<string[]>;
export declare let launchSession: CommandDefinition<void>;
export declare let resetApp: CommandDefinition<void>;
export declare let hideSoftKeyboard: CommandDefinition<void>;
export declare let getDeviceTime: CommandDefinition<string>;
export declare let openDeviceNotifications: CommandDefinition<void>;
export declare let rotationGesture: CommandDefinition<{}>;
export declare let shakeDevice: CommandDefinition<void>;
