var array;

module.exports = array = {

  /*
  	Tries to turn anything into an array.
   */
  from: function(r) {
    return Array.prototype.slice.call(r);
  },

  /*
  	Clone of an array. Properties will be shallow copies.
   */
  simpleClone: function(a) {
    return a.slice(0);
  },
  shallowEqual: function(a1, a2) {
    var i, val, _i, _len;
    if (!(Array.isArray(a1) && Array.isArray(a2) && a1.length === a2.length)) {
      return false;
    }
    for (i = _i = 0, _len = a1.length; _i < _len; i = ++_i) {
      val = a1[i];
      if (a2[i] !== val) {
        return false;
      }
    }
    return true;
  },
  pluck: function(a, i) {
    var index, value, _i, _len;
    if (a.length < 1) {
      return a;
    }
    for (index = _i = 0, _len = a.length; _i < _len; index = ++_i) {
      value = a[index];
      if (index > i) {
        a[index - 1] = a[index];
      }
    }
    a.length = a.length - 1;
    return a;
  },
  pluckItem: function(a, item) {
    var index, removed, value, _i, _len;
    if (a.length < 1) {
      return a;
    }
    removed = 0;
    for (index = _i = 0, _len = a.length; _i < _len; index = ++_i) {
      value = a[index];
      if (value === item) {
        removed++;
        continue;
      }
      if (removed !== 0) {
        a[index - removed] = a[index];
      }
    }
    if (removed > 0) {
      a.length = a.length - removed;
    }
    return a;
  },
  pluckOneItem: function(a, item) {
    var index, reached, value, _i, _len;
    if (a.length < 1) {
      return a;
    }
    reached = false;
    for (index = _i = 0, _len = a.length; _i < _len; index = ++_i) {
      value = a[index];
      if (!reached) {
        if (value === item) {
          reached = true;
          continue;
        }
      } else {
        a[index - 1] = a[index];
      }
    }
    if (reached) {
      a.length = a.length - 1;
    }
    return a;
  },
  pluckByCallback: function(a, cb) {
    var index, removed, value, _i, _len;
    if (a.length < 1) {
      return a;
    }
    removed = 0;
    for (index = _i = 0, _len = a.length; _i < _len; index = ++_i) {
      value = a[index];
      if (cb(value, index)) {
        removed++;
        continue;
      }
      if (removed !== 0) {
        a[index - removed] = a[index];
      }
    }
    if (removed > 0) {
      a.length = a.length - removed;
    }
    return a;
  },
  pluckMultiple: function(array, indexesToRemove) {
    var i, removedSoFar, _i, _len;
    if (array.length < 1) {
      return array;
    }
    removedSoFar = 0;
    indexesToRemove.sort();
    for (_i = 0, _len = indexesToRemove.length; _i < _len; _i++) {
      i = indexesToRemove[_i];
      this.pluck(array, i - removedSoFar);
      removedSoFar++;
    }
    return array;
  },
  injectByCallback: function(a, toInject, shouldInject) {
    var i, len, val, valA, valB, _i, _len;
    valA = null;
    valB = null;
    len = a.length;
    if (len < 1) {
      a.push(toInject);
      return a;
    }
    for (i = _i = 0, _len = a.length; _i < _len; i = ++_i) {
      val = a[i];
      valA = valB;
      valB = val;
      if (shouldInject(valA, valB, toInject)) {
        return a.splice(i, 0, toInject);
      }
    }
    a.push(toInject);
    return a;
  },
  injectInIndex: function(a, index, toInject) {
    var i, len, toPut, toPutNext;
    len = a.length;
    i = index;
    if (len < 1) {
      a.push(toInject);
      return a;
    }
    toPut = toInject;
    toPutNext = null;
    for(; i <= len; i++){

			toPutNext = a[i];

			a[i] = toPut;

			toPut = toPutNext;

		};
    return null;
  }
};

//# sourceMappingURL=data:application/json;base64,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