import {Component, OnInit, Input} from '@angular/core';
import {ActivatedRoute, Router} from '@angular/router';
import {Http, Headers} from '@angular/http';

@Component({
  selector: 'app-raypo-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.css']
})

export class raypoLoginComponent implements OnInit {
  @Input() serverAddress: any;
  public token: any;

  public loginData = {
    mobileNumber: '',
    smsCode: '',
  };

  public isLoading: any = false;
  public loginStep = '1';
  public isUserNew: any;
  public errorText: any;
  private _next: any;

  constructor(public router: Router,
              public route: ActivatedRoute,
              public http: Http) {
  }

  /*
      login API methods
  */

  sendMoblieNumber(mobileNumber) {
    console.log(mobileNumber);
    return this.http.post(this.serverAddress + '/user/register/',
      {
        mobile_number: mobileNumber
      });
  }

  login() {
    return this.http.post(this.serverAddress + '/user/register/', {
      mobile_number: this.loginData.mobileNumber,
      sms_code: this.loginData.smsCode,
      notif_uuid: ''
    });
  }

  checkToken(token) {
    const header = new Headers({
      'Authorization': 'Token ' + token,
      'Content-Type': 'application/json'
    });

    return this.http.get(this.serverAddress + '/user/check_token/', {headers: header});
  }

  /*
      End login API methods
  */


  loginFirstStep(moblieNumber) {
    this.isLoading = true;

    this.sendMoblieNumber(moblieNumber)
      .subscribe(
        (response) => {
          this.loginStep = '2';
          this.isUserNew = response.json().is_new_user;
          this.isLoading = false;
          this.errorText = '';
        },
        (error) => {
          if (error.json().error.code == '001') {
            this.errorText = 'شماره موبایل خود را با دقت وارد کنید';
          }
          console.log(error.json());
          this.isLoading = false;
        }
      );
  }


  loginSecondStep() {
    this.isLoading = true;
    this.login().subscribe(
      (respnose) => {
        this.token = respnose.json().token;
        this.checkToken(this.token).subscribe(
          (response) => {
            this.isLoading = false;
            if (response.json().data.user_type !== 'Business') {
              this.errorText = 'بیزنسی با این شماره وجود ندارد';
            } else {
              localStorage.setItem('token', this.token);
              this.errorText = '';
              location.href = '/';
            }
          }, (error) => {
            console.log(error);
          }
        );

      },
      (error) => {
        console.log(error);
        this.errorText = 'کد تایید صحیح نیست';
        this.isLoading = false;
      }
    );
  }


  setLastRoute() {
    this.route.queryParams.subscribe(
      (params) => {
        if (params.next) {
          this._next = params.next;
        } else {
          this._next = '/';
        }
      });
  }

  goToFirstStep() {
    this.loginStep = '1';
  }

  ngOnInit() {
    this.loginStep = '1';
    this.setLastRoute();
  }

}
